package org.dbunitng.annotations;

import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.ext.db2.Db2DataTypeFactory;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.dbunit.ext.hsqldb.HsqldbDataTypeFactory;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;

/**
 * データベースの種類。
 * 
 * @author jyukutyo
 * 
 */
public enum DatabaseType {

	ORACLE("oracle", new OracleDataTypeFactory()),

	SQLSERVER("sqlserver", new MsSqlDataTypeFactory()),

	DB2("db2", new Db2DataTypeFactory()),

	HSQLDB("hsqldb", new HsqldbDataTypeFactory()),

	H2("h2", new H2DataTypeFactory()),

	MYSQL("mysql", new MySqlDataTypeFactory()),

	OTHER("", null);

	/** データベース名 */
	private String name;

	/** データタイプのファクトリ */
	private IDataTypeFactory factory;

	/**
	 * プライベートコンストラクタ。
	 * 
	 * @param name
	 *            データベース名
	 * @param factory
	 *            データタイプのファクトリ
	 */
	private DatabaseType(String name, IDataTypeFactory factory) {
		this.name = name;
		this.factory = factory;
	}

	@Override
	public String toString() {
		return this.name;
	}

	/**
	 * データタイプのファクトリを返す。
	 * 
	 * @return データタイプのファクトリ
	 */
	public IDataTypeFactory getDataTypeFactory() {
		return this.factory;
	}

}
