/**
 * Copyright (c) 2004, yher2 project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.junit.db.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;

/**
 * @auther  hisaboh
 */
public class XmlDateTest extends TestCase {

	public void testGetValue() throws Exception {
		Map attribute = new HashMap();
		XmlDate date = new XmlDate(attribute);
		Date today = new Date();
		long diff = today.getTime()-((Date)date.getValue()).getTime();
		assertTrue(0<=diff && diff<100);
	}

	public void testGetValueWithValue() throws ParseException {
		Map attribute = new HashMap();
		attribute.put("value", "2004/12/12 17:50");
		XmlDate date = new XmlDate(attribute);
		SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm");
		Date expect = df.parse("2004/12/12 17:50");
		assertEquals(expect, date.getValue());
	}

	public void testGetValueWithValueAndFormat() throws ParseException {
		Map attribute = new HashMap();
		attribute.put("value", "2004/12/12");
		attribute.put("format", "yyyy/MM/dd");
		XmlDate date = new XmlDate(attribute);

		SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
		Date expect = df.parse("2004/12/12");
		assertEquals(expect, date.getValue());
	}

	public void testGetValueWithFormat() throws ParseException {
		Map attribute = new HashMap();
		attribute.put("format", "yyyy/MM/dd");
		XmlDate date = new XmlDate(attribute);

		SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
		Date expect = df.parse(df.format(new Date()));
		assertEquals(expect, date.getValue());
	}
}
