/**
 * Copyright (c) 2004, yher2 project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.junit.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import net.yher2.commons.io.Path;
import net.yher2.junit.db.data.Table;
import net.yher2.junit.db.excel.ExcelReader;

/**
 * @auther  hisaboh
 */
public class TestDataManager {
	static boolean pool;
	static Map dataMap;
	
	static {
		pool = true;
		dataMap = new HashMap();
	}
	private static Table[] getTable(Path path) throws IllegalStateException, IOException {
		if (pool) {
			Table[] table = (Table[])dataMap.get(path);
			if (table == null) {
				table = new ExcelReader(path).read();
			}
			return table;
		} else {
			return new ExcelReader(path).read();
		}
	}
	public static void enablePool() {
		pool = true;
	}
	public static void disablePool() {
		pool = false;
	}
	
	Connection con;
	public TestDataManager(Connection con) {
		this.con = con;
	}
	
	public void prepare(Path path) throws IOException, SQLException {
		insertExcel(path);
	}
	
	public void clear(Path path) throws IOException, SQLException {
		deleteExcel(path);
	}
	
	public void insert(Table table) throws SQLException {
		table.insert(con);
	}
	public void insertExcel(Path path) throws IOException, SQLException {
		ExcelReader reader = new ExcelReader(path);
		Table table[] = reader.read();
		for (int i=0; i<table.length; i++) {
			insert(table[i]);
		}
	}
	public void delete(Table table) throws SQLException {
		table.delete(con);
	}
	protected void deleteExcel(Path path) throws IOException, SQLException {
		ExcelReader reader = new ExcelReader(path);
		Table table[] = reader.read();
		for (int i=table.length-1; i>= 0; i--) {
			delete(table[i]);
		}
	}

}
