/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db.data;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class XmlParser {
    private String rawVal;
    private String xml;
    private String elementName;
    private Map attributeMap;

    public XmlParser(String xml) {
        this.rawVal = xml;
        this.attributeMap = new HashMap();
        this.normalize();
    }

    public String getXml() {
        return this.xml;
    }

    public boolean isXml() {
        return this.xml.matches("^<[^<>]+/>$");
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getAttribute(String name) {
        return (String)this.attributeMap.get(name);
    }

    public boolean hasAttribute(String name) {
        return this.attributeMap.containsKey(name);
    }

    public void parse() {
        if (!this.isXml()) {
            throw new IllegalArgumentException("This is not xml(" + this.rawVal + ")");
        }
        String xmlString = this.xml.replaceAll("[</>]", "");
        String[] str = xmlString.split("[ ]");
        this.elementName = str[0].toLowerCase();
        if (!this.elementName.matches("[a-zA-Z]+")) {
            throw new IllegalArgumentException("Invalid Element Name(" + this.elementName + ")");
        }
        int i = 1;
        while (i < str.length) {
            this.parseAttribute(str[i]);
            ++i;
        }
    }

    private void parseAttribute(String attribute) {
        String[] str = attribute.split("=");
        if (str.length != 2) {
            throw new IllegalArgumentException("Invalid attribute(" + attribute + ")");
        }
        String name = str[0].toLowerCase();
        String value = str[1].replaceAll("\"", "");
        value = URLDecoder.decode(value);
        value = StringEscapeUtils.unescapeXml((String)value);
        this.attributeMap.put(name, value);
    }

    public void normalize() {
        StringBuffer buf = new StringBuffer();
        char[] c = this.rawVal.toCharArray();
        boolean inQuote = false;
        int i = 0;
        while (i < c.length) {
            switch (c[i]) {
                case '\"': {
                    inQuote = !inQuote;
                    buf.append(c[i]);
                    break;
                }
                default: {
                    if (inQuote) {
                        buf.append(URLEncoder.encode("" + c[i]));
                        break;
                    }
                    buf.append(c[i]);
                }
            }
            ++i;
        }
        String result = buf.toString();
        result = result.replaceAll("[\n\r\t]", " ");
        result = result.replaceAll("[ ]+", " ");
        result = result.replaceAll("^[ ]+", "");
        result = result.replaceAll("[ ]+$", "");
        this.xml = result = result.replaceAll("[ ]*=[ ]*", "=");
    }
}

