/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import junit.framework.TestCase;
import net.yher2.junit.db.data.XmlDate;

public class XmlDateTest
extends TestCase {
    public void testGetValue() throws Exception {
        HashMap attribute = new HashMap();
        XmlDate date = new XmlDate(attribute);
        Date today = new Date();
        long diff = today.getTime() - date.getValue().getTime();
        XmlDateTest.assertTrue((0L <= diff && diff < 100L ? 1 : 0) != 0);
    }

    public void testGetValueWithValue() throws ParseException {
        HashMap<String, String> attribute = new HashMap<String, String>();
        attribute.put("value", "2004/12/12 17:50");
        XmlDate date = new XmlDate(attribute);
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        Date expect = df.parse("2004/12/12 17:50");
        XmlDateTest.assertEquals((Object)expect, (Object)date.getValue());
    }

    public void testGetValueWithValueAndFormat() throws ParseException {
        HashMap<String, String> attribute = new HashMap<String, String>();
        attribute.put("value", "2004/12/12");
        attribute.put("format", "yyyy/MM/dd");
        XmlDate date = new XmlDate(attribute);
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
        Date expect = df.parse("2004/12/12");
        XmlDateTest.assertEquals((Object)expect, (Object)date.getValue());
    }

    public void testGetValueWithFormat() throws ParseException {
        HashMap<String, String> attribute = new HashMap<String, String>();
        attribute.put("format", "yyyy/MM/dd");
        XmlDate date = new XmlDate(attribute);
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
        Date expect = df.parse(df.format(new Date()));
        XmlDateTest.assertEquals((Object)expect, (Object)date.getValue());
    }
}

