/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import net.yher2.commons.io.Classpath;
import net.yher2.commons.lang.DateUtils;
import net.yher2.junit.db.DBTestCaseTest;
import net.yher2.junit.db.TestDataManager;
import net.yher2.junit.db.data.ColumnData;
import net.yher2.junit.db.data.Header;
import net.yher2.junit.db.data.Row;
import net.yher2.junit.db.data.Table;
import net.yher2.junit.db.excel.ExcelReader;
import net.yher2.junit.db.test.data.Child;
import net.yher2.junit.db.test.data.Parent;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestDataManagerTest
extends DBTestCaseTest {
    Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    Connection con;
    TestDataManager manager;
    Table table;
    Row validRow1;
    Row validRow2;
    Row emptyRow;
    Row invalidRow;
    Date date;

    protected void setUp() throws Exception {
        super.setUp();
        this.date = new Date();
        this.table = new Table("PARENT");
        Header[] header = new Header[]{new Header("PARENT_ID", true), new Header("INT_VAL"), new Header("DBL_VAL"), new Header("VCR_VAL"), new Header("CHR_VAL"), new Header("DATE_VAL"), new Header("TIMESTAMP_VAL"), new Header("BOOL_VAL")};
        this.table.setHeader(header);
        this.validRow1 = new Row();
        this.validRow1.add(ColumnData.getInstance(new Integer(1)));
        this.validRow1.add(ColumnData.getInstance(new Integer(1)));
        this.validRow1.add(ColumnData.getInstance(new Double(0.9999)));
        this.validRow1.add(ColumnData.getInstance("hogehoge"));
        this.validRow1.add(ColumnData.getInstance("CHR"));
        this.validRow1.add(ColumnData.getInstance(this.date));
        this.validRow1.add(ColumnData.getInstance(this.date));
        this.validRow1.add(ColumnData.getInstance(new Boolean(true)));
        this.validRow2 = new Row();
        this.validRow2.add(ColumnData.getInstance(new Integer(2)));
        this.validRow2.add(ColumnData.getInstance(new Integer(2)));
        this.validRow2.add(ColumnData.getInstance(new Double(0.9999)));
        this.validRow2.add(ColumnData.getInstance("hogehoge"));
        this.validRow2.add(ColumnData.getInstance("CHR"));
        this.validRow2.add(ColumnData.getInstance(this.date));
        this.validRow2.add(ColumnData.getInstance(this.date));
        this.validRow2.add(ColumnData.getInstance(new Boolean(true)));
        this.emptyRow = new Row();
        this.emptyRow.add(ColumnData.getInstance(new Integer(3)));
        this.emptyRow.add(ColumnData.getInstance(null));
        this.emptyRow.add(ColumnData.getInstance(null));
        this.emptyRow.add(ColumnData.getInstance(null));
        this.emptyRow.add(ColumnData.getInstance(null));
        this.emptyRow.add(ColumnData.getInstance(null));
        this.emptyRow.add(ColumnData.getInstance(null));
        this.emptyRow.add(ColumnData.getInstance(null));
        this.invalidRow = new Row();
        this.invalidRow.add(ColumnData.getInstance(new Integer(4)));
        this.invalidRow.add(ColumnData.getInstance("hogehoge"));
        this.con = this.getConnection();
        this.manager = new TestDataManager(this.con);
    }

    protected void tearDown() throws Exception {
        this.con.rollback();
        super.tearDown();
        DbUtils.closeQuietly((Connection)this.con);
    }

    public void testInsertTable() throws Exception {
        this.table.addRow(this.validRow1);
        this.table.addRow(this.validRow2);
        this.manager.insert(this.table);
        Parent parent = this.getParent(this.con, 1);
        this.assertParent(this.validRow1, parent);
        parent = this.getParent(this.con, 2);
        this.assertParent(this.validRow2, parent);
    }

    public void testInsertTableEmpty() throws Exception {
        this.table.addRow(this.emptyRow);
        this.manager.insert(this.table);
        Parent parent = this.getParent(this.con, 3);
        TestDataManagerTest.assertEquals((int)3, (int)parent.getParentId());
        TestDataManagerTest.assertEquals((double)0.0, (double)parent.getDoubleValue(), (double)4.0);
        TestDataManagerTest.assertNull((Object)parent.getVarcharValue());
        TestDataManagerTest.assertNull((Object)parent.getCharValue());
        TestDataManagerTest.assertNull((Object)parent.getDateValue());
        TestDataManagerTest.assertNull((Object)parent.getTimestampValue());
        TestDataManagerTest.assertFalse((boolean)parent.isBooleanValue());
    }

    public void testInsertTableInvalid() throws Exception {
        this.table.addRow(this.invalidRow);
        try {
            this.manager.insert(this.table);
        }
        catch (SQLException e) {
            return;
        }
        TestDataManagerTest.fail();
    }

    public void testInsertExcel() throws Exception {
        Classpath path = new Classpath("net/yher2/junit/db/excel/DatabaseManagerTest.xls");
        ExcelReader reader = new ExcelReader(path);
        Table[] table = reader.read();
        this.manager.insertExcel(path);
        Parent parent1 = this.getParent(this.con, 1);
        Parent parent2 = this.getParent(this.con, 2);
        Parent parent3 = this.getParent(this.con, 3);
        Row[] row = table[0].getRow();
        this.assertParent(row[0], parent1);
        this.assertParent(row[1], parent2);
        this.assertParent(row[2], parent3);
        Child child1 = this.getChild(this.con, 1);
        Child child2 = this.getChild(this.con, 2);
        Child child3 = this.getChild(this.con, 3);
        row = table[1].getRow();
        this.assertChild(row[0], child1);
        this.assertChild(row[1], child2);
        this.assertChild(row[2], child3);
    }

    public void testDeleteTable() throws Exception {
        this.table.addRow(this.validRow1);
        this.table.addRow(this.validRow2);
        this.manager.insert(this.table);
        this.manager.delete(this.table);
        TestDataManagerTest.assertNull((Object)this.getParent(this.con, 1));
        TestDataManagerTest.assertNull((Object)this.getParent(this.con, 2));
    }

    public void testDeleteExcel() throws Exception {
        Classpath path = new Classpath("net/yher2/junit/db/excel/DatabaseManagerTest.xls");
        ExcelReader reader = new ExcelReader(path);
        this.manager.insertExcel(path);
        this.manager.deleteExcel(path);
        TestDataManagerTest.assertNull((Object)this.getParent(this.con, 1));
        TestDataManagerTest.assertNull((Object)this.getParent(this.con, 2));
        TestDataManagerTest.assertNull((Object)this.getParent(this.con, 3));
        TestDataManagerTest.assertNull((Object)this.getChild(this.con, 1));
        TestDataManagerTest.assertNull((Object)this.getChild(this.con, 2));
        TestDataManagerTest.assertNull((Object)this.getChild(this.con, 3));
    }

    private void assertParent(Row row, Parent parent) {
        ColumnData[] column = row.getColumn();
        TestDataManagerTest.assertEquals((Object)((Integer)column[0].getValue()), (Object)new Integer(parent.getParentId()));
        TestDataManagerTest.assertEquals((Object)((Integer)column[1].getValue()), (Object)new Integer(parent.getIntValue()));
        TestDataManagerTest.assertEquals((double)((Double)column[2].getValue()), (double)parent.getDoubleValue(), (double)4.0);
        TestDataManagerTest.assertEquals((Object)column[3].getValue(), (Object)parent.getVarcharValue());
        TestDataManagerTest.assertEquals((Object)column[4].getValue(), (Object)parent.getCharValue());
        this.log.debug(column[5].getValue());
        this.log.debug((Object)parent.getDateValue());
        this.assertEquals(DateUtils.toSqlDate((Date)column[5].getValue()), parent.getDateValue());
        TestDataManagerTest.assertEquals((Object)column[6].getValue(), (Object)parent.getTimestampValue());
        TestDataManagerTest.assertEquals((Object)column[7].getValue(), (Object)new Boolean(parent.isBooleanValue()));
    }

    private void assertChild(Row row, Child parent) {
        ColumnData[] column = row.getColumn();
        TestDataManagerTest.assertEquals((Object)((Integer)column[0].getValue()), (Object)new Integer(parent.getChildId()));
        TestDataManagerTest.assertEquals((Object)((Integer)column[1].getValue()), (Object)new Integer(parent.getParentId()));
        TestDataManagerTest.assertEquals((Object)((Integer)column[2].getValue()), (Object)new Integer(parent.getIntValue()));
        TestDataManagerTest.assertEquals((double)((Double)column[3].getValue()), (double)parent.getDoubleValue(), (double)4.0);
        TestDataManagerTest.assertEquals((Object)column[4].getValue(), (Object)parent.getVarcharValue());
        TestDataManagerTest.assertEquals((Object)column[5].getValue(), (Object)parent.getCharValue());
        this.assertEquals(DateUtils.toSqlDate((Date)column[6].getValue()), parent.getDateValue());
        TestDataManagerTest.assertEquals((Object)column[7].getValue(), (Object)parent.getTimestampValue());
        TestDataManagerTest.assertEquals((Object)column[8].getValue(), (Object)new Boolean(parent.isBooleanValue()));
    }
}

