/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.RowProcessor;

public class ResultSetIterator
implements Iterator {
    private ResultSet rs = null;
    private RowProcessor convert = BasicRowProcessor.instance();

    public ResultSetIterator(ResultSet rs) {
        this.rs = rs;
    }

    public ResultSetIterator(ResultSet rs, RowProcessor convert) {
        this.rs = rs;
        this.convert = convert;
    }

    public boolean hasNext() {
        try {
            return !this.rs.isLast();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public Object next() {
        try {
            this.rs.next();
            return this.convert.toArray(this.rs);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void remove() {
        try {
            this.rs.deleteRow();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

