package jp.dbdiffreport;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.List;

public class DdrDbExport {

	public static void main(String[] args) throws Exception {

		DdrUtil.debug(DdrDbExport.class.getSimpleName());
		long start = System.currentTimeMillis();

		String dir = new SimpleDateFormat("yyyyMMddHHmmss").format(start);
		if (args.length > 0) dir = args[0];

		dbExport(dir, DdrUtil.getProperties());
		dbExport(dir, DdrUtil.getProperties("other."));

		DdrUtil.debug("end " + (System.currentTimeMillis() - start) + "ms");
	}

	private static void dbExport(String dir, DdrProperties p) throws Exception {

		if (p.getDriver() == null
		||	p.getUrl() == null
		||	p.getTableList() == null) return;

		DdrUtil.debug("  " + p.getUrl());
		long start = System.currentTimeMillis();

		Connection con = DdrUtil.getConnection(p);
		Statement st = con.createStatement();

		new File(dir).mkdirs();
		for (String table : p.getTableList()) {
			tableExport(con, st, dir, p.getSchema(), table);
		}

		st.close();
		con.close();

		DdrUtil.debug("  end " + (System.currentTimeMillis() - start) + "ms");
	}

	private static final String DELIMITER = "\t";

	private static void tableExport(Connection con, Statement st, String dir, String schema, String table) throws Exception {

		long start = System.currentTimeMillis();

		String select = "select * from " + table;
		List<String> pkeyList = DdrUtil.getPrimaryKeys(con, schema, table);
		if (pkeyList.size() != 0) {
			String s = "";
			for (String pkey : pkeyList) {
				if (s.length() != 0) {
					s += ",";
				}
				s += pkey;
			}
			select += " order by " + s;
		}

		ResultSet rs = st.executeQuery(select);
		ResultSetMetaData rsmd = rs.getMetaData();

		File file = new File(dir, table + ".txt");
		PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));

		pw.print(table);
		int cols = rsmd.getColumnCount();
		for (int i = 0; i < cols; i++) {
			pw.print(DELIMITER);
			pw.print(rsmd.getColumnName(i + 1));
		}
		pw.println();

		int row = 0;
		while (rs.next()) {
			row++;
			for (int i = 0; i < cols; i++) {
				pw.print(DELIMITER);
				pw.print(rs.getString(i + 1));
			}
			pw.println();
		}
		pw.close();

		DdrUtil.debug("    " + table + " | " + row + " rows | " + (System.currentTimeMillis() - start) + " ms | " + select);
	}
}
