/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.Hashtable;
import java.util.Properties;
import java.util.PropertyPermission;

public class FrameworkProperties {
    private static Properties properties;
    private static final String USING_SYSTEM_PROPERTIES_KEY = "osgi.framework.useSystemProperties";

    static {
        Properties systemProperties = System.getProperties();
        String usingSystemProperties = systemProperties.getProperty(USING_SYSTEM_PROPERTIES_KEY);
        if (usingSystemProperties == null || usingSystemProperties.equalsIgnoreCase(Boolean.TRUE.toString())) {
            properties = systemProperties;
        } else {
            properties = new Properties();
            ((Hashtable)properties).putAll(systemProperties);
        }
    }

    public static Properties getProperties() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        return properties;
    }

    public static String getProperty(String key) {
        return FrameworkProperties.getProperty(key, null);
    }

    public static String getProperty(String key, String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return properties.getProperty(key, defaultValue);
    }

    public static String setProperty(String key, String value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return ((Hashtable)properties).put(key, value);
    }

    public static String clearProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return (String)((Hashtable)properties).remove(key);
    }
}

