/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;

public class DetailObservableMap
extends ObservableMap {
    private boolean updating = false;
    private IObservableValue master;
    private IObservableFactory detailFactory;
    private IObservableMap detailMap;
    private IValueChangeListener masterChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            HashMap oldMap = new HashMap(DetailObservableMap.this.wrappedMap);
            DetailObservableMap.this.updateDetailMap();
            DetailObservableMap.this.fireMapChange(Diffs.computeMapDiff(oldMap, DetailObservableMap.this.wrappedMap));
        }
    };
    private IMapChangeListener detailChangeListener = new IMapChangeListener(){

        public void handleMapChange(MapChangeEvent event) {
            if (!DetailObservableMap.this.updating) {
                DetailObservableMap.this.fireMapChange(event.diff);
            }
        }
    };

    public DetailObservableMap(IObservableFactory detailFactory, IObservableValue master) {
        super(master.getRealm(), Collections.EMPTY_MAP);
        this.master = master;
        this.detailFactory = detailFactory;
        this.updateDetailMap();
        master.addValueChangeListener(this.masterChangeListener);
    }

    private void updateDetailMap() {
        Object masterValue = this.master.getValue();
        if (this.detailMap != null) {
            this.detailMap.removeMapChangeListener(this.detailChangeListener);
            this.detailMap.dispose();
        }
        if (masterValue == null) {
            this.detailMap = null;
            this.wrappedMap = Collections.EMPTY_MAP;
        } else {
            this.detailMap = (IObservableMap)this.detailFactory.createObservable(masterValue);
            this.wrappedMap = this.detailMap;
            this.detailMap.addMapChangeListener(this.detailChangeListener);
        }
    }

    public Object put(Object key, Object value) {
        return this.detailMap.put(key, value);
    }

    public void putAll(Map map) {
        this.detailMap.putAll(map);
    }

    public Object remove(Object key) {
        return this.detailMap.remove(key);
    }

    public void clear() {
        this.detailMap.clear();
    }

    public synchronized void dispose() {
        if (this.master != null) {
            this.master.removeValueChangeListener(this.masterChangeListener);
            this.master = null;
            this.masterChangeListener = null;
        }
        this.detailFactory = null;
        if (this.detailMap != null) {
            this.detailMap.removeMapChangeListener(this.detailChangeListener);
            this.detailMap.dispose();
            this.detailMap = null;
        }
        this.detailChangeListener = null;
        super.dispose();
    }
}

