/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.actions;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public class ShowReferenceItemAction
implements IViewActionDelegate {
    private Document document = null;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.document == null) {
            return;
        }
        try {
            ArrayList<Document> refdocs = DataDomImpl.getReferenceDocuments(this.document);
            if (refdocs == null) {
                MessageDialog.openInformation(null, (String)"No items found", (String)"No reference items found.");
                return;
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ConciergeViewPart tabulator = (ConciergeViewPart)page.findView("jp.sourceforge.concierge.plugin.tabulator");
            String title = "Reference items of (" + DataDomImpl.getFileName(this.document) + ")";
            if ((tabulator == null || !tabulator.getPartName().equals("Tabulator") && !tabulator.getPartName().equals(title)) && (tabulator = (ConciergeViewPart)page.showView("jp.sourceforge.concierge.plugin.tabulator", title, 3)) == null) {
                return;
            }
            tabulator.setPartProperty("TITLE", title);
            tabulator.setDocuments(refdocs);
            page.activate((IWorkbenchPart)tabulator);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel == null || sel.size() == 0) {
            this.document = null;
            return;
        }
        this.document = (Document)sel.getFirstElement();
    }
}

