/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlButtonContentInfo;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.HIThemePopupArrowDrawInfo;
import org.eclipse.swt.internal.carbon.HIThemeSeparatorDrawInfo;
import org.eclipse.swt.internal.carbon.HIThemeTextInfo;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    int handle;
    int iconHandle;
    int labelHandle;
    int cIcon;
    int visibleRgn;
    int partCode;
    int width = 6;
    ToolBar parent;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    Control control;
    boolean selection;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;
    static final int DEFAULT_SEPARATOR_WIDTH = 6;
    static final int ARROW_WIDTH = 9;
    static final int INSET = 3;
    static final String[] AX_ATTRIBUTES = new String[]{"AXDescription", "AXTitle", "AXValue"};

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    int actionProc(int theControl, int partCode) {
        int transform;
        int result = this.parent.actionProc(theControl, partCode);
        if (result == 0) {
            return result;
        }
        if (this.isDisposed()) {
            return 0;
        }
        this.partCode = partCode;
        if (this.text.length() > 0 && theControl == this.labelHandle) {
            if (this.image != null && this.iconHandle != 0) {
                transform = partCode != 0 ? 16384 : 0;
                OS.SetControlData(this.iconHandle, 0, 1953654381, 2, new short[]{(short)transform});
                this.redrawWidget(this.iconHandle, false);
            }
            this.redrawWidget(this.labelHandle, false);
        }
        if (this.image != null && theControl == this.iconHandle) {
            this.redrawWidget(this.labelHandle, false);
        }
        if (theControl == this.handle) {
            if (this.image != null && this.iconHandle != 0) {
                transform = partCode != 0 ? 16384 : 0;
                OS.SetControlData(this.iconHandle, 0, 1953654381, 2, new short[]{(short)transform});
                this.redrawWidget(this.iconHandle, false);
            }
            if (this.labelHandle != 0) {
                this.redrawWidget(this.labelHandle, false);
            }
        }
        return result;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        if (control == this.labelHandle && (this.partCode != 0 || (this.state & 8) != 0 && OS.VERSION >= 4160)) {
            HIThemeTextInfo info = new HIThemeTextInfo();
            info.state = this.partCode != 0 ? 2 : (OS.IsControlActive(this.labelHandle) ? ((this.state & 8) == 0 ? 1 : 7) : ((this.state & 8) == 0 ? 0 : 8));
            Font font = this.parent.font;
            if (font != null) {
                short[] family = new short[1];
                short[] style = new short[1];
                OS.FMGetFontFamilyInstanceFromFont(font.handle, family, style);
                OS.TextFont(family[0]);
                OS.TextFace((short)(style[0] | font.style));
                OS.TextSize((short)font.size);
                info.fontID = (short)200;
            } else {
                info.fontID = (short)this.parent.defaultThemeFont();
            }
            CGRect rect = new CGRect();
            OS.HIViewGetBounds(this.labelHandle, rect);
            int[] context = new int[1];
            OS.GetEventParameter(theEvent, 1668183160, 1668183160, null, 4, null, context);
            if ((this.state & 8) != 0 && OS.VERSION >= 4160) {
                OS.HIThemeSetTextFill(36, 0, context[0], 0);
            } else {
                int colorspace = OS.CGColorSpaceCreateDeviceRGB();
                OS.CGContextSetFillColorSpace(context[0], colorspace);
                OS.CGColorSpaceRelease(colorspace);
                OS.CGContextSetFillColor(context[0], this.parent.getForegroundColor().handle);
            }
            int[] ptr = new int[1];
            OS.GetControlData(this.labelHandle, (short)0, 1667658612, 4, ptr, null);
            OS.HIThemeDrawTextBox(ptr[0], rect, info, context[0], 0);
            OS.CFRelease(ptr[0]);
            return 0;
        }
        if (control == this.iconHandle && OS.VERSION >= 4160) {
            int imageHandle;
            int alphaInfo;
            Image image = null;
            image = this.hotImage != null ? this.hotImage : (this.image != null ? this.image : this.disabledImage);
            if (image != null && (alphaInfo = OS.CGImageGetAlphaInfo(imageHandle = image.handle)) == 4) {
                int[] buffer = new int[1];
                OS.GetEventParameter(theEvent, 1668183160, 1668183160, null, 4, null, buffer);
                int context = buffer[0];
                CGRect rect = new CGRect();
                OS.HIViewGetBounds(this.iconHandle, rect);
                if (this.partCode != 0) {
                    OS.HICreateTransformedCGImage(imageHandle, 16384, buffer);
                    imageHandle = buffer[0];
                } else if ((this.state & 8) != 0) {
                    OS.HICreateTransformedCGImage(imageHandle, 1, buffer);
                    imageHandle = buffer[0];
                }
                OS.HIViewDrawCGImage(context, rect, imageHandle);
                if (imageHandle != image.handle) {
                    OS.CGImageRelease(imageHandle);
                }
                return 0;
            }
        }
        return super.callPaintEventHandler(control, damageRgn, visibleRgn, theEvent, nextHandler);
    }

    static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int colorProc(int inControl, int inMessage, int inDrawDepth, int inDrawInColor) {
        switch (inMessage) {
            case 30: {
                if (this.parent.foreground != null) {
                    OS.RGBForeColor(this.toRGBColor(this.parent.foreground));
                } else {
                    OS.SetThemeTextColor((short)1, (short)inDrawDepth, inDrawInColor != 0);
                }
                return 0;
            }
            case 23: {
                float[] background;
                float[] fArray = background = this.parent.background != null ? this.parent.background : this.parent.getParentBackground();
                if (background != null) {
                    OS.RGBBackColor(this.toRGBColor(background));
                } else {
                    OS.SetThemeBackground((short)1, (short)inDrawDepth, inDrawInColor != 0);
                }
                return 0;
            }
        }
        return -9874;
    }

    Point computeSize() {
        int width = 0;
        int height = 0;
        if ((this.style & 2) != 0) {
            if ((this.parent.style & 0x100) != 0) {
                width = this.getWidth();
                height = 22;
            } else {
                width = 24;
                height = this.getWidth();
            }
            if (this.control != null) {
                height = Math.max(height, this.control.getMininumHeight());
            }
        } else {
            int space = 0;
            if (this.text.length() != 0 || this.image != null) {
                int stringWidth = 0;
                int stringHeight = 0;
                if (this.text.length() != 0) {
                    Point size = this.textExtent();
                    stringWidth = size.x;
                    stringHeight = size.y;
                }
                int imageWidth = 0;
                int imageHeight = 0;
                if (this.image != null) {
                    if (this.text.length() != 0) {
                        space = 2;
                    }
                    Rectangle rect = this.image.getBounds();
                    imageWidth = rect.width;
                    imageHeight = rect.height;
                }
                if ((this.parent.style & 0x20000) != 0) {
                    width = stringWidth + imageWidth + space;
                    height = Math.max(stringHeight, imageHeight);
                } else {
                    width = Math.max(stringWidth, imageWidth);
                    height = stringHeight + imageHeight + space;
                }
            } else {
                width = 24;
                height = 22;
            }
            if ((this.style & 4) != 0) {
                width += 9;
            }
            width += 6;
            height += 6;
        }
        return new Point(width, height);
    }

    boolean contains(String[] array, String element) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void createHandle() {
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        int features = 18;
        OS.CreateUserPaneControl(window, null, features, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        OS.HIObjectSetAccessibilityIgnored(this.handle, true);
        if ((this.style & 2) == 0) {
            ControlButtonContentInfo inContent = new ControlButtonContentInfo();
            OS.CreateIconControl(window, null, inContent, false, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.iconHandle = outControl[0];
            OS.HIObjectSetAccessibilityIgnored(this.iconHandle, true);
            ControlFontStyleRec fontStyle = new ControlFontStyleRec();
            Font font = this.parent.font;
            if (font != null) {
                short[] family = new short[1];
                short[] style = new short[1];
                OS.FMGetFontFamilyInstanceFromFont(font.handle, family, style);
                fontStyle.flags = (short)(fontStyle.flags | 7);
                fontStyle.font = family[0];
                fontStyle.style = (short)(style[0] | font.style);
                fontStyle.size = (short)font.size;
            } else {
                fontStyle.flags = (short)128;
                fontStyle.font = (short)this.parent.defaultThemeFont();
            }
            OS.CreateStaticTextControl(window, null, 0, fontStyle, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.labelHandle = outControl[0];
            OS.HIObjectSetAccessibilityIgnored(this.labelHandle, true);
        }
    }

    void createWidget() {
        super.createWidget();
        this.setZOrder();
        this.toolTipText = "";
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.iconHandle != 0) {
            this.display.removeWidget(this.iconHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        int theControl = this.handle;
        this.releaseHandle();
        if (theControl != 0) {
            OS.DisposeControl(theControl);
        }
    }

    void drawBackground(int control, int context) {
        if (control == this.handle && this.getSelection()) {
            CGRect rect = new CGRect();
            OS.HIViewGetBounds(this.handle, rect);
            OS.CGContextSaveGState(context);
            OS.CGContextSetFillColor(context, new float[]{0.1f, 0.1f, 0.1f, 0.1f});
            OS.CGContextFillRect(context, rect);
            OS.CGContextSetStrokeColor(context, new float[]{0.2f, 0.2f, 0.2f, 0.2f});
            rect.x += 0.5f;
            rect.y += 0.5f;
            rect.width -= 1.0f;
            rect.height -= 1.0f;
            OS.CGContextStrokeRect(context, rect);
            OS.CGContextRestoreGState(context);
        }
    }

    void drawWidget(int control, int context, int damageRgn, int visibleRgn, int theEvent) {
        if (control == this.handle && (this.style & 6) != 0) {
            Object info;
            int state = OS.IsControlEnabled(control) ? (OS.IsControlActive(control) ? 1 : 0) : (OS.IsControlActive(control) ? 7 : 8);
            CGRect rect = new CGRect();
            OS.HIViewGetBounds(this.handle, rect);
            if ((this.style & 2) != 0 && this.control == null) {
                rect.y += 2.0f;
                rect.height -= 4.0f;
                info = new HIThemeSeparatorDrawInfo();
                ((HIThemeSeparatorDrawInfo)info).state = state;
                OS.HIThemeDrawSeparator(rect, (HIThemeSeparatorDrawInfo)info, context, 0);
            }
            if ((this.style & 4) != 0) {
                rect.y = rect.height / 2.0f - 1.0f;
                rect.x = rect.width - 9.0f;
                info = new HIThemePopupArrowDrawInfo();
                ((HIThemePopupArrowDrawInfo)info).state = state;
                ((HIThemePopupArrowDrawInfo)info).orientation = 1;
                ((HIThemePopupArrowDrawInfo)info).size = 1;
                OS.HIThemeDrawPopupArrow(rect, (HIThemePopupArrowDrawInfo)info, context, 0);
            }
        }
    }

    String[] getAxAttributes() {
        return AX_ATTRIBUTES;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getControlBounds(this.handle);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    int getDrawCount(int control) {
        return this.parent.getDrawCount(control);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.selection;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(control, this.visibleRgn, false);
        }
        int result = OS.NewRgn();
        OS.CopyRgn(this.visibleRgn, result);
        return result;
    }

    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        if (this.parent.toolTipText == null) {
            switch (inRequest) {
                case 0: {
                    short[] contentProvided = new short[]{-1};
                    if (this.toolTipText != null && this.toolTipText.length() != 0) {
                        char[] buffer = new char[this.toolTipText.length()];
                        this.toolTipText.getChars(0, buffer.length, buffer, 0);
                        int length = this.fixMnemonic(buffer);
                        if (this.display.helpString != 0) {
                            OS.CFRelease(this.display.helpString);
                        }
                        this.display.helpString = OS.CFStringCreateWithCharacters(0, buffer, length);
                        HMHelpContentRec helpContent = new HMHelpContentRec();
                        OS.memmove(helpContent, ioHelpContent, 534);
                        helpContent.version = 3;
                        helpContent.tagSide = 0;
                        this.display.helpWidget = null;
                        helpContent.absHotRect_left = 0;
                        helpContent.absHotRect_top = 0;
                        helpContent.absHotRect_right = 0;
                        helpContent.absHotRect_bottom = 0;
                        helpContent.content0_contentType = 1667658612;
                        helpContent.content0_tagCFString = this.display.helpString;
                        helpContent.content1_contentType = 1667658612;
                        helpContent.content1_tagCFString = this.display.helpString;
                        OS.memmove(ioHelpContent, helpContent, 534);
                        contentProvided[0] = 0;
                    }
                    OS.memmove(outContentProvided, contentProvided, 2);
                    break;
                }
                case 1: {
                    if (this.display.helpString != 0) {
                        OS.CFRelease(this.display.helpString);
                    }
                    this.display.helpWidget = null;
                    this.display.helpString = 0;
                }
            }
            return 0;
        }
        return this.parent.helpProc(inControl, inGlobalMouse, inRequest, outContentProvided, ioHelpContent);
    }

    void hookEvents() {
        super.hookEvents();
        int controlProc = this.display.controlProc;
        int colorProc = this.display.colorProc;
        int[] mask1 = new int[]{1668183148, 4, 1668183148, 1, 1668183148, 3, 1668183148, 51};
        int controlTarget = OS.GetControlEventTarget(this.handle);
        OS.InstallEventHandler(controlTarget, controlProc, mask1.length / 2, mask1, this.handle, null);
        int[] mask2 = new int[]{1668183148, 4, 1668183148, 3, 1668183148, 51, 1668183148, 17};
        int accessibilityProc = this.display.accessibilityProc;
        int[] mask3 = new int[]{1633903461, 21, 1633903461, 22};
        if (this.iconHandle != 0) {
            controlTarget = OS.GetControlEventTarget(this.iconHandle);
            OS.InstallEventHandler(controlTarget, controlProc, mask2.length / 2, mask2, this.iconHandle, null);
            OS.SetControlColorProc(this.iconHandle, colorProc);
            OS.SetControlAction(this.iconHandle, this.display.actionProc);
            OS.InstallEventHandler(controlTarget, accessibilityProc, mask3.length / 2, mask3, this.iconHandle, null);
        }
        if (this.labelHandle != 0) {
            controlTarget = OS.GetControlEventTarget(this.labelHandle);
            OS.InstallEventHandler(controlTarget, controlProc, mask2.length / 2, mask2, this.labelHandle, null);
            OS.SetControlColorProc(this.labelHandle, colorProc);
            OS.SetControlAction(this.labelHandle, this.display.actionProc);
        }
        if ((this.style & 2) == 0) {
            OS.SetControlAction(this.handle, this.display.actionProc);
        }
        int helpProc = this.display.helpProc;
        OS.HMInstallControlContentCallback(this.handle, helpProc);
        OS.SetControlColorProc(this.handle, colorProc);
    }

    void invalidateVisibleRegion(int control) {
        this.resetVisibleRegion(control);
        this.parent.resetVisibleRegion(control);
    }

    void invalWindowRgn(int window, int rgn) {
        this.parent.invalWindowRgn(window, rgn);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    int kEventAccessibleGetAllAttributeNames(int nextHandler, int theEvent, int userData) {
        int code = -9874;
        String[] attributes = this.getAxAttributes();
        if (attributes != null) {
            OS.CallNextEventHandler(nextHandler, theEvent);
            int[] arrayRef = new int[1];
            OS.GetEventParameter(theEvent, 1635020403, 1667657057, null, 4, null, arrayRef);
            int attributesArrayRef = arrayRef[0];
            int length = OS.CFArrayGetCount(attributesArrayRef);
            String[] osAttributes = new String[length];
            int i = 0;
            while (i < length) {
                int stringRef = OS.CFArrayGetValueAtIndex(attributesArrayRef, i);
                int strLength = OS.CFStringGetLength(stringRef);
                char[] buffer = new char[strLength];
                CFRange range = new CFRange();
                range.length = strLength;
                OS.CFStringGetCharacters(stringRef, range, buffer);
                osAttributes[i] = new String(buffer);
                ++i;
            }
            i = 0;
            while (i < attributes.length) {
                if (!this.contains(osAttributes, attributes[i])) {
                    String string = attributes[i];
                    char[] buffer = new char[string.length()];
                    string.getChars(0, buffer.length, buffer, 0);
                    int stringRef = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                    OS.CFArrayAppendValue(attributesArrayRef, stringRef);
                    OS.CFRelease(stringRef);
                }
                ++i;
            }
            code = 0;
        }
        if (this.parent.accessible != null) {
            code = this.parent.accessible.internal_kEventAccessibleGetAllAttributeNames(nextHandler, theEvent, code);
        }
        return code;
    }

    int kEventAccessibleGetNamedAttribute(int nextHandler, int theEvent, int userData) {
        int code = -9874;
        int[] stringRef = new int[1];
        OS.GetEventParameter(theEvent, 1635020397, 1667658612, null, 4, null, stringRef);
        int length = 0;
        if (stringRef[0] != 0) {
            length = OS.CFStringGetLength(stringRef[0]);
        }
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(stringRef[0], range, buffer);
        String attributeName = new String(buffer);
        if (attributeName.equals("AXRole") || attributeName.equals("AXRoleDescription")) {
            String roleText;
            String string = (this.style & 8) != 0 ? "AXButton" : ((this.style & 0x10) != 0 ? "AXRadioButton" : ((this.style & 0x20) != 0 ? "AXCheckBox" : (roleText = (this.style & 4) != 0 ? "AXMenuButton" : null)));
            if (roleText != null) {
                buffer = new char[roleText.length()];
                roleText.getChars(0, buffer.length, buffer, 0);
                stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                if (stringRef[0] != 0) {
                    if (attributeName.equals("AXRole")) {
                        OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                    } else {
                        int stringRef2 = OS.HICopyAccessibilityRoleDescription(stringRef[0], 0);
                        OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef2});
                        OS.CFRelease(stringRef2);
                    }
                    OS.CFRelease(stringRef[0]);
                    code = 0;
                }
            }
        } else if (attributeName.equals("AXTitle") || attributeName.equals("AXDescription")) {
            String accessibleText = this.toolTipText;
            if (accessibleText == null || accessibleText.equals("")) {
                accessibleText = this.text;
            }
            if (accessibleText != null && !accessibleText.equals("")) {
                buffer = new char[accessibleText.length()];
                accessibleText.getChars(0, buffer.length, buffer, 0);
                int ref = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{ref});
                OS.CFRelease(ref);
                code = 0;
            }
        } else if (attributeName.equals("AXValue") && (this.style & 0x30) != 0) {
            OS.SetEventParameter(theEvent, 1635022444, 1819242087, 4, new int[]{this.selection ? 1 : 0});
            code = 0;
        }
        if (this.parent.accessible != null) {
            code = this.parent.accessible.internal_kEventAccessibleGetNamedAttribute(nextHandler, theEvent, code);
        }
        return code;
    }

    int kEventControlGetClickActivation(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventControlGetClickActivation(nextHandler, theEvent, userData);
    }

    int kEventControlHit(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlHit(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        }
        this.postEvent(13);
        return -9874;
    }

    int kEventControlHitTest(int nextHandler, int theEvent, int userData) {
        if (this.display.clickCountButton == 2) {
            return 0;
        }
        int[] theControl = new int[1];
        OS.GetEventParameter(theEvent, 0x2D2D2D2D, 1668575852, null, 4, null, theControl);
        if (theControl[0] == this.labelHandle || theControl[0] == this.handle && (this.style & 2) == 0) {
            CGRect rect = new CGRect();
            OS.HIViewGetBounds(theControl[0], rect);
            CGPoint pt = new CGPoint();
            OS.GetEventParameter(theEvent, 1835822947, 1751740532, null, 8, null, pt);
            if (OS.CGRectContainsPoint(rect, pt) != 0 && (theControl[0] != this.handle || (this.style & 4) == 0 || rect.width - pt.x >= 12.0f)) {
                OS.SetEventParameter(theEvent, 1668313716, 1668313716, 2, new short[]{1});
                return 0;
            }
        }
        return -9874;
    }

    int kEventControlTrack(int nextHandler, int theEvent, int userData) {
        int result = this.parent.kEventControlTrack(nextHandler, theEvent, userData);
        if (this.isDisposed()) {
            return 0;
        }
        this.partCode = 0;
        if (this.text.length() > 0 && this.labelHandle != 0) {
            this.redrawWidget(this.labelHandle, false);
        }
        if (this.image != null && this.iconHandle != 0) {
            OS.SetControlData(this.iconHandle, 0, 1953654381, 2, new short[1]);
            this.redrawWidget(this.iconHandle, false);
        }
        return result;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int result = this.parent.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.style & 4) != 0) {
            CGPoint pt = new CGPoint();
            OS.GetEventParameter(theEvent, 2003660661, 1751740532, null, 8, null, pt);
            OS.HIViewConvertPoint(pt, 0, this.handle);
            CGRect rect = new CGRect();
            OS.HIViewGetFrame(this.handle, rect);
            int x = (int)pt.x;
            int width = (int)rect.width;
            if (width - x < 12) {
                OS.HIViewConvertPoint(pt, this.handle, this.parent.handle);
                Event event = new Event();
                event.detail = 4;
                event.x = (int)rect.x;
                event.y = (int)(rect.y + rect.height);
                this.postEvent(13, event);
            }
        }
        return result;
    }

    int kEventMouseDragged(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventMouseDragged(nextHandler, theEvent, userData);
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventMouseMoved(nextHandler, theEvent, userData);
    }

    int kEventMouseUp(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventMouseUp(nextHandler, theEvent, userData);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.iconHandle != 0) {
            this.display.addWidget(this.iconHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseParent() {
        super.releaseParent();
        this.setVisible(false);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.iconHandle = 0;
        this.handle = 0;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
        }
        this.cIcon = 0;
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
        }
        this.visibleRgn = 0;
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resetVisibleRegion(int control) {
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
            this.visibleRgn = 0;
        }
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    void setBackground(float[] color) {
        this.parent.setBackground(this.handle, color);
        if (this.labelHandle != 0) {
            this.parent.setBackground(this.labelHandle, color);
        }
        if (this.iconHandle != 0) {
            this.parent.setBackground(this.iconHandle, color);
        }
    }

    void setBounds(int x, int y, int width, int height) {
        this.setBounds(this.handle, x, y, width, height, true, true, false);
        if ((this.style & 2) != 0) {
            return;
        }
        int space = 0;
        int stringWidth = 0;
        int stringHeight = 0;
        if (this.text.length() != 0) {
            Point size = this.textExtent();
            stringWidth = size.x;
            stringHeight = size.y;
        }
        int imageWidth = 0;
        int imageHeight = 0;
        if (this.image != null) {
            if (this.text.length() != 0) {
                space = 2;
            }
            Rectangle rect = this.image.getBounds();
            imageWidth = rect.width;
            imageHeight = rect.height;
        }
        int arrowWidth = 0;
        if ((this.style & 4) != 0) {
            arrowWidth = 9;
        }
        if ((this.parent.style & 0x20000) != 0) {
            int imageX = 3;
            int imageY = 3 + (height - 6 - imageHeight) / 2;
            this.setBounds(this.iconHandle, imageX, imageY, imageWidth, imageHeight, true, true, false);
            int labelX = imageX + imageWidth + space;
            int labelY = 3 + (height - 6 - stringHeight) / 2;
            this.setBounds(this.labelHandle, labelX, labelY, stringWidth, stringHeight, true, true, false);
        } else {
            int imageX = 3 + (width - 6 - arrowWidth - imageWidth) / 2;
            int imageY = 3 + (height - imageHeight - stringHeight - 6) / 2;
            this.setBounds(this.iconHandle, imageX, imageY, imageWidth, imageHeight, true, true, false);
            int labelX = 3 + (width - 6 - arrowWidth - stringWidth) / 2;
            int labelY = imageY + imageHeight + space;
            this.setBounds(this.labelHandle, labelX, labelY, stringWidth, stringHeight, true, true, false);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        this.redrawWidget(this.handle, false);
        if (control != null && !control.isDisposed()) {
            control.moveAbove(null);
        }
        this.parent.relayout();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 && enabled) {
            return;
        }
        if (enabled) {
            this.state &= 0xFFFFFFF7;
            OS.EnableControl(this.handle);
        } else {
            this.state |= 8;
            OS.DisableControl(this.handle);
        }
    }

    void setFontStyle(Font font) {
        this.parent.setFontStyle(this.labelHandle, font);
    }

    void setForeground(float[] color) {
        this.parent.setForeground(this.handle, color);
        if (this.labelHandle != 0) {
            this.parent.setForeground(this.labelHandle, color);
        }
        if (this.iconHandle != 0) {
            this.parent.setForeground(this.iconHandle, color);
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        this.updateImage(true);
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        this.updateImage(true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.updateImage(true);
        OS.HIObjectSetAccessibilityIgnored(this.iconHandle, image == null);
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.selection = selected;
        this.redrawWidget(this.handle, true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, length);
        if (ptr == 0) {
            this.error(13);
        }
        OS.SetControlData(this.labelHandle, 0, 1667658612, 4, new int[]{ptr});
        OS.CFRelease(ptr);
        this.redrawWidget(this.labelHandle, false);
        this.parent.relayout();
        OS.HIObjectSetAccessibilityIgnored(this.labelHandle, string.equals(""));
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    void setVisible(boolean visible) {
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        this.setVisible(this.handle, visible);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < 0 || this.width == width) {
            return;
        }
        this.width = width;
        this.redrawWidget(this.handle, false);
        this.parent.relayout();
    }

    void setZOrder() {
        OS.HIViewAddSubview(this.parent.handle, this.handle);
        if (this.iconHandle != 0) {
            OS.HIViewAddSubview(this.handle, this.iconHandle);
        }
        if (this.labelHandle != 0) {
            OS.HIViewAddSubview(this.handle, this.labelHandle);
        }
    }

    void updateImage(boolean layout) {
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
        }
        this.cIcon = 0;
        Image image = null;
        image = this.hotImage != null ? this.hotImage : (this.image != null ? this.image : this.disabledImage);
        ControlButtonContentInfo inContent = new ControlButtonContentInfo();
        if (image != null) {
            this.cIcon = this.createCIcon(image);
            inContent.contentType = (short)130;
            inContent.iconRef = this.cIcon;
        }
        OS.SetBevelButtonContentInfo(this.iconHandle, inContent);
        if (layout) {
            this.redrawWidget(this.iconHandle, false);
            this.parent.relayout();
        }
    }

    Point textExtent() {
        int[] ptr = new int[1];
        OS.GetControlData(this.labelHandle, (short)0, 1667658612, 4, ptr, null);
        Point result = this.parent.textExtent(ptr[0], 0);
        if (ptr[0] != 0) {
            OS.CFRelease(ptr[0]);
        }
        return result;
    }
}

