/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.HIThemeTrackDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.SliderTrackInfo;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ScaleDrawData
extends RangeDrawData {
    public int increment;
    public int pageIncrement;

    public ScaleDrawData() {
        this.state = new int[4];
    }

    HIThemeTrackDrawInfo getInfo() {
        int upTrackState = this.state[1];
        int downTrackState = this.state[2];
        int thumbState = this.state[3];
        HIThemeTrackDrawInfo info = new HIThemeTrackDrawInfo();
        info.min = this.minimum;
        info.max = Math.max(this.minimum, this.maximum);
        info.value = this.selection;
        info.kind = (short)2;
        info.attributes = (short)4;
        if ((this.style & 0x100) != 0) {
            info.attributes = (short)(info.attributes | 1);
        }
        info.enableState = (byte)3;
        if ((this.state[0] & 0x10) != 0) {
            info.enableState = 0;
        }
        if ((this.state[0] & 0x20) != 0) {
            info.enableState = 1;
        }
        info.slider = new SliderTrackInfo();
        int state = 0;
        if ((upTrackState & 8) != 0) {
            state |= 2;
        }
        if ((downTrackState & 8) != 0) {
            state |= 0x20;
        }
        if ((thumbState & 8) != 0) {
            state |= 8;
        }
        info.slider.pressState = (byte)state;
        return info;
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        HIThemeTrackDrawInfo info = this.getInfo();
        info.bounds_x = bounds.x;
        info.bounds_y = bounds.y;
        info.bounds_width = bounds.width;
        info.bounds_height = bounds.height;
        OS.HIThemeDrawTrack(info, null, gc.handle, 0);
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        if (!bounds.contains(position)) {
            return -1;
        }
        CGPoint pt = new CGPoint();
        pt.x = position.x;
        pt.y = position.y;
        short[] part = new short[1];
        HIThemeTrackDrawInfo info = this.getInfo();
        if (OS.HIThemeHitTestTrack(info, pt, part)) {
            switch (part[0]) {
                case 22: {
                    return 1;
                }
                case 23: {
                    return 2;
                }
                case 129: {
                    return 3;
                }
            }
        }
        return -1;
    }
}

