/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.searcher.widget;

import jp.sourceforge.concierge.plugin.searcher.SearchCalendar;
import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.plugin.searcher.data.PeriodType;
import jp.sourceforge.concierge.plugin.searcher.data.SearchType;
import jp.sourceforge.concierge.plugin.searcher.widget.DateComposite;
import jp.sourceforge.concierge.util.XPathString;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Element;

public class PeriodComposite
extends Composite {
    private Combo periodKindCombo = null;
    private Group gpBase = null;
    private Composite periodBase = null;
    private Composite inputComp = null;
    private Combo dateSelectCombo = null;
    private DateInterval selectInterval = null;
    private DateNumber monthNumber = null;
    private DateNumber dayNumber = null;
    private DateNumber weekNumber = null;
    private DateExact selectDate = null;
    private Action updateAction = null;

    public void setUpdateAction(Action act) {
        this.updateAction = act;
    }

    public PeriodComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        this.gpBase = new Group((Composite)this, 0);
        this.gpBase.setLayout((Layout)new FormLayout());
        this.gpBase.setLayoutData((Object)new GridData(768));
        this.gpBase.setText("Date range");
        this.periodKindCombo = new Combo((Composite)this.gpBase, 8);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 12);
        fd.left = new FormAttachment(0, 10);
        this.periodKindCombo.setLayoutData((Object)fd);
        this.periodKindCombo.add("Create date");
        this.periodKindCombo.add("Modified date");
        this.periodKindCombo.select(0);
        this.periodKindCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PeriodComposite.this.updateAction != null) {
                    PeriodComposite.this.updateAction.run();
                }
            }
        });
        this.dateSelectCombo = new Combo((Composite)this.gpBase, 8);
        FormData fd1 = new FormData();
        fd1.top = new FormAttachment(0, 12);
        fd1.left = new FormAttachment((Control)this.periodKindCombo, 10);
        this.dateSelectCombo.setLayoutData((Object)fd1);
        this.dateSelectCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PeriodComposite.this.updateAction != null) {
                    PeriodComposite.this.updateAction.run();
                }
            }
        });
        this.dateSelectCombo.add("Not specify");
        this.dateSelectCombo.add("Today");
        this.dateSelectCombo.add(".. days before");
        this.dateSelectCombo.add("This week");
        this.dateSelectCombo.add(".. weeks before");
        this.dateSelectCombo.add("This month");
        this.dateSelectCombo.add(".. months before");
        this.dateSelectCombo.add("Date range");
        this.dateSelectCombo.add("[After/Before] specified date");
        this.dateSelectCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Combo comb = (Combo)e.getSource();
                int index = comb.getSelectionIndex();
                switch (index) {
                    case 0: {
                        PeriodComposite.this.setPeriodNone();
                        break;
                    }
                    case 1: {
                        PeriodComposite.this.setToday();
                        break;
                    }
                    case 2: {
                        PeriodComposite.this.setBeforeDay(1);
                        break;
                    }
                    case 3: {
                        PeriodComposite.this.setToday();
                        break;
                    }
                    case 4: {
                        PeriodComposite.this.setBeforeWeek(1);
                        break;
                    }
                    case 5: {
                        PeriodComposite.this.setToday();
                        break;
                    }
                    case 6: {
                        PeriodComposite.this.setBeforeMonth(1);
                        break;
                    }
                    case 7: {
                        SearchCalendar st = new SearchCalendar();
                        st.setLastDay(7);
                        SearchCalendar ed = new SearchCalendar();
                        PeriodComposite.this.setInterval(st, ed);
                        break;
                    }
                    case 8: {
                        PeriodComposite.this.setDate(new SearchCalendar(), PeriodType.EXACT_A_DAY);
                        break;
                    }
                    default: {
                        PeriodComposite.this.setPeriodNone();
                    }
                }
            }
        });
        this.dateSelectCombo.select(0);
        this.createBase();
    }

    private void createBase() {
        this.periodBase = new Composite((Composite)this.gpBase, 0);
        this.periodBase.setLayout((Layout)new FormLayout());
        FormData fd = new FormData();
        fd.top = new FormAttachment((Control)this.periodKindCombo, 5);
        fd.left = new FormAttachment(0, 0);
        this.periodBase.setLayoutData((Object)fd);
        this.selectInterval = new DateInterval(this.periodBase);
        FormData fd1 = new FormData();
        fd1.top = new FormAttachment((Control)this.periodKindCombo, 0);
        fd1.left = new FormAttachment((Control)this.dateSelectCombo, 8);
        this.selectInterval.setLayoutData(fd1);
        this.selectInterval.setVisible(false);
        this.selectDate = new DateExact(this.periodBase, PeriodType.EXACT_A_DAY);
        FormData fd2 = new FormData();
        fd2.top = new FormAttachment((Control)this.periodKindCombo, 0);
        fd2.left = new FormAttachment((Control)this.dateSelectCombo, 5);
        this.selectDate.setLayoutData(fd2);
        this.selectDate.setVisible(false);
        this.monthNumber = new DateNumber(this.periodBase, PeriodType.MONTHS_BEFORE);
        FormData fd3 = new FormData();
        fd3.top = new FormAttachment((Control)this.periodKindCombo, 0);
        fd3.left = new FormAttachment((Control)this.dateSelectCombo, 5);
        this.monthNumber.setLayoutData(fd3);
        this.monthNumber.setVisible(false);
        this.dayNumber = new DateNumber(this.periodBase, PeriodType.DAYS_BEFORE);
        FormData fd4 = new FormData();
        fd4.top = new FormAttachment((Control)this.periodKindCombo, 0);
        fd4.left = new FormAttachment((Control)this.dateSelectCombo, 5);
        this.dayNumber.setLayoutData(fd4);
        this.dayNumber.setVisible(false);
        this.weekNumber = new DateNumber(this.periodBase, PeriodType.WEEKS_BEFORE);
        FormData fd5 = new FormData();
        fd5.top = new FormAttachment((Control)this.periodKindCombo, 0);
        fd5.left = new FormAttachment((Control)this.dateSelectCombo, 5);
        this.weekNumber.setLayoutData(fd5);
        this.weekNumber.setVisible(false);
        this.inputComp = this.selectInterval;
    }

    public void setPeriodNone() {
        this.periodKindCombo.setEnabled(false);
        this.inputComp.setVisible(false);
        this.layout();
    }

    public void setToday() {
        this.inputComp.setVisible(false);
        this.periodKindCombo.setEnabled(true);
        this.layout();
    }

    public void setBeforeDay(int nday) {
        this.inputComp.setVisible(false);
        this.layout();
        this.dayNumber.setDate(nday);
        this.dayNumber.setPeriodType(PeriodType.DAYS_BEFORE);
        this.inputComp = this.dayNumber;
        this.inputComp.setVisible(true);
        this.layout();
        this.inputComp.setEnabled(true);
        this.periodKindCombo.setEnabled(true);
    }

    public int getBeforeDay() {
        return this.dayNumber.getDate();
    }

    public void setBeforeWeek(int nweek) {
        this.inputComp.setVisible(false);
        this.layout();
        this.weekNumber.setDate(nweek);
        this.weekNumber.setPeriodType(PeriodType.WEEKS_BEFORE);
        this.inputComp = this.weekNumber;
        this.inputComp.setVisible(true);
        this.layout();
        this.inputComp.setEnabled(true);
        this.periodKindCombo.setEnabled(true);
    }

    public int getBeforeWeek() {
        return this.weekNumber.getDate();
    }

    public void setBeforeMonth(int nmonth) {
        this.inputComp.setVisible(false);
        this.layout();
        this.monthNumber.setDate(nmonth);
        this.monthNumber.setPeriodType(PeriodType.MONTHS_BEFORE);
        this.inputComp = this.monthNumber;
        this.inputComp.setVisible(true);
        this.layout();
        this.inputComp.setEnabled(true);
        this.periodKindCombo.setEnabled(true);
    }

    public int getBeforeMonth() {
        return this.monthNumber.getDate();
    }

    public void setInterval(SearchCalendar start, SearchCalendar end) {
        this.inputComp.setVisible(false);
        this.layout();
        start.setBeginTime();
        end.setEndTime();
        this.selectInterval.setStartDate(start);
        this.selectInterval.setEndDate(end);
        this.inputComp = this.selectInterval;
        this.inputComp.setVisible(true);
        this.inputComp.setEnabled(true);
        this.periodKindCombo.setEnabled(true);
    }

    public SearchCalendar getStartDate() {
        SearchCalendar out = new SearchCalendar();
        this.selectInterval.getStartDate(out);
        return out;
    }

    public SearchCalendar getEndDate() {
        SearchCalendar out = new SearchCalendar();
        this.selectInterval.getEndDate(out);
        return out;
    }

    public void setDate(SearchCalendar date, PeriodType type) {
        this.inputComp.setVisible(false);
        this.layout();
        this.selectDate.setDate(date);
        this.selectDate.setType(type);
        this.inputComp = this.selectDate;
        this.inputComp.setVisible(true);
        this.inputComp.setEnabled(true);
        this.periodKindCombo.setEnabled(true);
        this.layout();
    }

    public SearchCalendar getDate() {
        SearchCalendar out = new SearchCalendar();
        this.selectDate.getDate(out);
        return out;
    }

    public PeriodType getPeriodType() {
        return this.selectDate.getType();
    }

    public void setDatePattern(PeriodType type) {
        switch (type) {
            case NONE: {
                this.dateSelectCombo.select(0);
                break;
            }
            case THIS_DAY: {
                this.dateSelectCombo.select(1);
                break;
            }
            case DAYS_BEFORE: {
                this.dateSelectCombo.select(2);
                break;
            }
            case THIS_WEEK: {
                this.dateSelectCombo.select(3);
                break;
            }
            case WEEKS_BEFORE: {
                this.dateSelectCombo.select(4);
                break;
            }
            case THIS_MONTH: {
                this.dateSelectCombo.select(5);
                break;
            }
            case MONTHS_BEFORE: {
                this.dateSelectCombo.select(6);
                break;
            }
            case INTERVAL: {
                this.dateSelectCombo.select(7);
                break;
            }
            case EXACT_A_DAY: {
                this.selectDate.setType(PeriodType.EXACT_A_DAY);
                this.dateSelectCombo.select(8);
            }
            case BEFORE_A_DAY: {
                this.selectDate.setType(PeriodType.BEFORE_A_DAY);
                this.dateSelectCombo.select(8);
            }
            case AFTER_A_DAY: {
                this.selectDate.setType(PeriodType.AFTER_A_DAY);
                this.dateSelectCombo.select(8);
            }
        }
    }

    public PeriodType getDatePattern() {
        int index = this.dateSelectCombo.getSelectionIndex();
        switch (index) {
            case 0: {
                return PeriodType.NONE;
            }
            case 1: {
                return PeriodType.THIS_DAY;
            }
            case 2: {
                return PeriodType.DAYS_BEFORE;
            }
            case 3: {
                return PeriodType.THIS_WEEK;
            }
            case 4: {
                return PeriodType.WEEKS_BEFORE;
            }
            case 5: {
                return PeriodType.THIS_MONTH;
            }
            case 6: {
                return PeriodType.MONTHS_BEFORE;
            }
            case 7: {
                return PeriodType.INTERVAL;
            }
            case 8: {
                return this.selectDate.ptype;
            }
        }
        return PeriodType.NONE;
    }

    public void setSearchType(SearchType type) {
        this.periodKindCombo.setVisible(true);
        this.periodKindCombo.setEnabled(true);
        switch (type) {
            case CREATEDATE: {
                this.periodKindCombo.select(0);
                break;
            }
            case MODIFIEDDATE: {
                this.periodKindCombo.select(1);
            }
        }
    }

    public SearchType getSearchType() {
        if (this.periodKindCombo.getSelectionIndex() == 0) {
            return SearchType.CREATEDATE;
        }
        return SearchType.MODIFIEDDATE;
    }

    public void save(Element info) {
        PeriodType pt = this.getDatePattern();
        Configure.setModRangePattern(info, pt);
        SearchType st = this.getSearchType();
        Configure.setModRangeStamp(info, st);
        switch (pt) {
            case NONE: {
                break;
            }
            case THIS_DAY: {
                break;
            }
            case DAYS_BEFORE: {
                Configure.setModRangeSinceDate(info, this.dayNumber.getDate());
                break;
            }
            case THIS_WEEK: {
                break;
            }
            case WEEKS_BEFORE: {
                Configure.setModRangeSinceWeek(info, this.weekNumber.getDate());
                break;
            }
            case THIS_MONTH: {
                break;
            }
            case MONTHS_BEFORE: {
                Configure.setModRangeSinceMonth(info, this.monthNumber.getDate());
                break;
            }
            case INTERVAL: {
                SearchCalendar start = new SearchCalendar();
                this.selectInterval.getStartDate(start);
                Configure.setModIntervalRangeStartDate(info, start);
                SearchCalendar end = new SearchCalendar();
                this.selectInterval.getEndDate(end);
                Configure.setModIntervalRangeEndDate(info, end);
                break;
            }
            case EXACT_A_DAY: {
                SearchCalendar exd = new SearchCalendar();
                this.selectDate.getDate(exd);
                Configure.setOneDateCalendar(info, exd);
                Configure.setOneDatePeriodType(info, PeriodType.EXACT_A_DAY);
                break;
            }
            case BEFORE_A_DAY: {
                SearchCalendar exbd = new SearchCalendar();
                this.selectDate.getDate(exbd);
                Configure.setOneDateCalendar(info, exbd);
                Configure.setOneDatePeriodType(info, PeriodType.BEFORE_A_DAY);
                break;
            }
            case AFTER_A_DAY: {
                SearchCalendar exad = new SearchCalendar();
                this.selectDate.getDate(exad);
                Configure.setOneDateCalendar(info, exad);
                Configure.setOneDatePeriodType(info, PeriodType.AFTER_A_DAY);
            }
        }
    }

    public void load(Element info) {
        this.setSearchType(Configure.getModRangeStamp(info));
        PeriodType pt = Configure.getModRangePattern(info);
        this.setDatePattern(pt);
        switch (pt) {
            case NONE: {
                break;
            }
            case THIS_DAY: {
                break;
            }
            case DAYS_BEFORE: {
                this.setBeforeDay(Configure.getModRangeSinceDate(info));
                break;
            }
            case THIS_WEEK: {
                break;
            }
            case WEEKS_BEFORE: {
                this.setBeforeWeek(Configure.getModRangeSinceWeek(info));
                break;
            }
            case THIS_MONTH: {
                break;
            }
            case MONTHS_BEFORE: {
                this.setBeforeMonth(Configure.getModRangeSinceMonth(info));
                break;
            }
            case INTERVAL: {
                SearchCalendar start = Configure.getModIntervalRangeStartDate(info);
                SearchCalendar end = Configure.getModIntervalRangeEndDate(info);
                this.setInterval(start, end);
                break;
            }
            case EXACT_A_DAY: {
                this.setDate(Configure.getOneDateCalendar(info), PeriodType.EXACT_A_DAY);
                break;
            }
            case BEFORE_A_DAY: {
                this.setDate(Configure.getOneDateCalendar(info), PeriodType.BEFORE_A_DAY);
                break;
            }
            case AFTER_A_DAY: {
                this.setDate(Configure.getOneDateCalendar(info), PeriodType.AFTER_A_DAY);
            }
        }
    }

    public void update() {
    }

    public String getXPath() {
        if (this.dateSelectCombo.getSelectionIndex() == 0) {
            return "";
        }
        String pk = "";
        pk = this.periodKindCombo.getSelectionIndex() == 0 ? "id" : "lastmod";
        PeriodType dp = this.getDatePattern();
        long s = 0L;
        long e = 0L;
        SearchCalendar st = new SearchCalendar();
        switch (dp) {
            case THIS_DAY: {
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case THIS_WEEK: {
                st.setLastWeekStart(0);
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setLastWeekEnd(0);
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case THIS_MONTH: {
                st.setLastMonthStart(0);
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setLastMonthEnd(0);
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case DAYS_BEFORE: {
                st.setLastDay(this.dayNumber.getDate());
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case WEEKS_BEFORE: {
                st.setLastWeekStart(this.weekNumber.getDate());
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setLastWeekEnd(this.weekNumber.getDate());
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case MONTHS_BEFORE: {
                st.setLastMonthStart(this.monthNumber.getDate());
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setLastMonthEnd(this.monthNumber.getDate());
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case INTERVAL: {
                this.selectInterval.getStartDate(st);
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setToday();
                this.selectInterval.getEndDate(st);
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case EXACT_A_DAY: {
                this.selectDate.getDate(st);
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case BEFORE_A_DAY: {
                s = 0L;
                this.selectDate.getDate(st);
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case AFTER_A_DAY: {
                this.selectDate.getDate(st);
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.set(2030, 12, 31);
                e = st.getTimeInMillis();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return XPathString.getAttributeBetweenPredicate((String)pk, (String)String.valueOf(e), (String)String.valueOf(s));
    }

    private class DateExact
    extends Composite
    implements DateRange {
        private DateComposite date;
        private Combo unitComb;
        private PeriodType ptype;

        public void setType(PeriodType type) {
            switch (type) {
                case EXACT_A_DAY: {
                    this.unitComb.select(0);
                    break;
                }
                case BEFORE_A_DAY: {
                    this.unitComb.select(1);
                    break;
                }
                case AFTER_A_DAY: {
                    this.unitComb.select(2);
                }
            }
            this.ptype = type;
        }

        public PeriodType getType() {
            return this.ptype;
        }

        public void getDate(SearchCalendar out) {
            this.date.getDate(out);
        }

        public void setDate(SearchCalendar in) {
            this.date.setDate(in);
        }

        public void setEnable(boolean b) {
            this.date.setSelectable(b);
            this.unitComb.setEnabled(b);
        }

        public DateExact(Composite parent, PeriodType type) {
            super(parent, 0);
            this.date = null;
            this.unitComb = null;
            this.setLayout((Layout)new GridLayout(3, false));
            this.unitComb = new Combo((Composite)this, 8);
            this.unitComb.add("In");
            this.unitComb.add("Before");
            this.unitComb.add("After");
            this.unitComb.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    switch (DateExact.this.unitComb.getSelectionIndex()) {
                        case 0: {
                            PeriodComposite.this.selectDate.ptype = PeriodType.EXACT_A_DAY;
                            break;
                        }
                        case 1: {
                            PeriodComposite.this.selectDate.ptype = PeriodType.BEFORE_A_DAY;
                            break;
                        }
                        case 2: {
                            PeriodComposite.this.selectDate.ptype = PeriodType.AFTER_A_DAY;
                        }
                    }
                }
            });
            this.date = new DateComposite(this);
            this.date.setLayout((Layout)new FormLayout());
            this.setType(type);
        }

        public long getEndDate() {
            switch (this.ptype) {
                case EXACT_A_DAY: 
                case BEFORE_A_DAY: {
                    SearchCalendar cale = new SearchCalendar();
                    this.date.getDate(cale);
                    return cale.getTimeInMillis();
                }
                case AFTER_A_DAY: {
                    return Long.MAX_VALUE;
                }
            }
            return 0L;
        }

        public long getStartDate() {
            switch (this.ptype) {
                case EXACT_A_DAY: 
                case AFTER_A_DAY: {
                    SearchCalendar cale = new SearchCalendar();
                    this.date.getDate(cale);
                    return cale.getTimeInMillis();
                }
                case BEFORE_A_DAY: {
                    return 0L;
                }
            }
            return 0L;
        }
    }

    private class DateInterval
    extends Composite
    implements DateRange {
        private DateComposite compStart;
        private DateComposite compEnd;
        private Label lbInt;
        private Label lbLast;

        public void setStartDate(SearchCalendar cal) {
            this.compStart.setDate(cal);
        }

        public void getStartDate(SearchCalendar out) {
            assert (out != null);
            this.compStart.getDate(out);
            out.setBeginTime();
        }

        public void setEndDate(SearchCalendar cal) {
            this.compEnd.setDate(cal);
        }

        public void getEndDate(SearchCalendar out) {
            assert (out != null);
            this.compEnd.getDate(out);
            out.setEndTime();
        }

        public void setEnable(boolean b) {
            this.compStart.setSelectable(b);
            this.compEnd.setSelectable(b);
            this.lbInt.setEnabled(b);
            this.lbLast.setEnabled(b);
        }

        public DateInterval(Composite parent) {
            super(parent, 0);
            this.compStart = null;
            this.compEnd = null;
            this.lbInt = null;
            this.lbLast = null;
            this.setLayout((Layout)new FormLayout());
            this.compStart = new DateComposite(this);
            this.compStart.setLayout((Layout)new FormLayout());
            FormData fdS = new FormData();
            fdS.top = new FormAttachment(0, 5);
            fdS.left = new FormAttachment(0, 0);
            this.compStart.setLayoutData(fdS);
            this.lbInt = new Label((Composite)this, 0);
            this.lbInt.setText("-");
            FormData fdL = new FormData();
            fdL.top = new FormAttachment(0, 5);
            fdL.left = new FormAttachment((Control)this.compStart, 2);
            this.lbInt.setLayoutData((Object)fdL);
            this.compEnd = new DateComposite(this);
            this.compEnd.setLayout((Layout)new FormLayout());
            FormData fdE = new FormData();
            fdE.top = new FormAttachment(0, 5);
            fdE.left = new FormAttachment((Control)this.lbInt, 2);
            this.compEnd.setLayoutData(fdE);
            this.lbLast = new Label((Composite)this, 0);
            this.lbLast.setText("");
            FormData fdL2 = new FormData();
            fdL2.top = new FormAttachment(0, 5);
            fdL2.left = new FormAttachment((Control)this.compEnd, 2);
            this.lbLast.setLayoutData((Object)fdL2);
        }

        public long getEndDate() {
            SearchCalendar cale = new SearchCalendar();
            this.getEndDate(cale);
            return cale.getTimeInMillis();
        }

        public long getStartDate() {
            SearchCalendar cals = new SearchCalendar();
            this.getStartDate(cals);
            return cals.getTimeInMillis();
        }
    }

    private class DateNumber
    extends Composite
    implements DateRange {
        private Combo numberCombo;
        private Label unitLabel;
        private PeriodType ptype;

        public int getDate() {
            return Integer.parseInt(this.numberCombo.getText());
        }

        public void setDate(int num) {
            this.numberCombo.setText(String.valueOf(num));
        }

        public void setEnable(boolean b) {
            this.numberCombo.setEnabled(b);
            this.unitLabel.setEnabled(b);
        }

        public void setPeriodType(PeriodType type) {
            switch (type) {
                case DAYS_BEFORE: {
                    this.unitLabel.setText("days before");
                    break;
                }
                case WEEKS_BEFORE: {
                    this.unitLabel.setText("weeks before");
                    break;
                }
                case MONTHS_BEFORE: {
                    this.unitLabel.setText("months before");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.ptype = type;
        }

        public PeriodType getPeriodType() {
            return this.ptype;
        }

        public DateNumber(Composite parent, PeriodType type) {
            super(parent, 0);
            this.numberCombo = null;
            this.unitLabel = null;
            this.setLayout((Layout)new GridLayout(2, false));
            this.numberCombo = new Combo((Composite)this, 8);
            int i = 1;
            while (i < 11) {
                this.numberCombo.add(Integer.toString(i));
                ++i;
            }
            this.numberCombo.select(0);
            this.numberCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (PeriodComposite.this.updateAction != null) {
                        PeriodComposite.this.updateAction.run();
                    }
                }
            });
            this.unitLabel = new Label((Composite)this, 0);
            this.setPeriodType(type);
        }

        public long getEndDate() {
            SearchCalendar cale = new SearchCalendar();
            cale.setEndTime();
            int val = this.getDate();
            switch (this.ptype) {
                case DAYS_BEFORE: {
                    cale.setLastDay(val);
                    return cale.getTimeInMillis();
                }
                case WEEKS_BEFORE: {
                    cale.setLastWeekEnd(val);
                    return cale.getTimeInMillis();
                }
                case MONTHS_BEFORE: {
                    cale.setLastMonthEnd(val);
                    return cale.getTimeInMillis();
                }
            }
            assert (false);
            return 0L;
        }

        public long getStartDate() {
            SearchCalendar cals = new SearchCalendar();
            cals.setBeginTime();
            int val = this.getDate();
            switch (this.ptype) {
                case DAYS_BEFORE: {
                    cals.setLastDay(val);
                    return cals.getTimeInMillis();
                }
                case WEEKS_BEFORE: {
                    cals.setLastWeekStart(val);
                    return cals.getTimeInMillis();
                }
                case MONTHS_BEFORE: {
                    cals.setLastMonthStart(val);
                    return cals.getTimeInMillis();
                }
            }
            assert (false);
            return 0L;
        }
    }

    private static interface DateRange {
        public long getStartDate();

        public long getEndDate();
    }
}

