/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.searcher.data;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.searcher.SearchCalendar;
import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.plugin.searcher.data.ConjunctionType;
import jp.sourceforge.concierge.plugin.searcher.data.PeriodType;
import jp.sourceforge.concierge.plugin.searcher.data.SearchType;
import jp.sourceforge.concierge.plugin.searcher.data.WordCondition;
import jp.sourceforge.concierge.util.XPathString;
import org.w3c.dom.Element;

public class XPathCreator {
    private static final String ALL_TYPES = "All type";
    private static final String ALL_ITEMS = "All item";
    private static final String ONLY_FILE = "File name";
    private static final String ONLY_FILEINFO = "File information";

    private String getTypePredicate(String type) {
        return "data[" + XPathString.getAttributeEqualsPredicate((String)"name", (String)type) + "]";
    }

    private String getAllWordsXPath(String str, String type, String item) {
        String v = str.trim();
        if (v.length() == 0) {
            return "";
        }
        String pred = type.equals(ALL_TYPES) ? "" : String.valueOf(this.getTypePredicate(type)) + " and ";
        String[] words = v.split(" ");
        ArrayList<String> ws = new ArrayList<String>();
        int i = 0;
        while (i < words.length) {
            ws.add(words[i]);
            ++i;
        }
        String predstr = "[" + XPathString.getElementContainsPredicate(ws, (String)" and ", (boolean)true, (boolean)false) + "]";
        pred = item.equals(ONLY_FILE) ? String.valueOf(pred) + XPathString.getAttributeContainsPredicate((String)"filename", ws, (String)" and ", (boolean)false) : (item.equals(ONLY_FILEINFO) ? String.valueOf(pred) + "fileinfo" + predstr : (item.equals(ALL_ITEMS) ? String.valueOf(pred) + "data" + predstr + " or " + "fileinfo" + predstr : String.valueOf(pred) + "data" + "/" + item + predstr));
        return pred;
    }

    private String getPhraseXPath(String str, String type, String item) {
        String v = str.trim();
        if (v.length() == 0) {
            return "";
        }
        String pred = type.equals(ALL_TYPES) ? "" : String.valueOf(this.getTypePredicate(type)) + " and ";
        String predstr = "[" + XPathString.getElementContainsPredicate((String)v, (boolean)true) + "]";
        pred = item.equals(ONLY_FILE) ? String.valueOf(pred) + XPathString.getAttributeContainsPredicate((String)"filename", (String)v) : (item.equals(ONLY_FILEINFO) ? String.valueOf(pred) + "fileinfo" + predstr : (item.equals(ALL_ITEMS) ? String.valueOf(pred) + "data" + predstr + " or " + "fileinfo" + predstr : String.valueOf(pred) + "data" + "/" + item + predstr));
        return pred;
    }

    private String getAtLeastXPath(String str, String type, String item) {
        String v = str.trim();
        if (v.length() == 0) {
            return "";
        }
        String pred = type.equals(ALL_TYPES) ? "" : String.valueOf(this.getTypePredicate(type)) + " and ";
        String[] words = v.split(" ");
        ArrayList<String> ws = new ArrayList<String>();
        int i = 0;
        while (i < words.length) {
            ws.add(words[i]);
            ++i;
        }
        String predstr = "[" + XPathString.getElementContainsPredicate(ws, (String)" or ", (boolean)true, (boolean)false) + "]";
        pred = item.equals(ONLY_FILE) ? String.valueOf(pred) + XPathString.getAttributeContainsPredicate((String)"filename", ws, (String)" or ", (boolean)false) : (item.equals(ONLY_FILEINFO) ? String.valueOf(pred) + "fileinfo" + predstr : (item.equals(ALL_ITEMS) ? String.valueOf(pred) + "data" + predstr + " or " + "fileinfo" + predstr : String.valueOf(pred) + "data" + "/" + item + predstr));
        return pred;
    }

    private String getNoneXPath(String str, String type, String item) {
        String v = str.trim();
        if (v.length() == 0) {
            return "";
        }
        String pred = type.equals(ALL_TYPES) ? "" : String.valueOf(this.getTypePredicate(type)) + " and ";
        String[] words = v.split(" ");
        ArrayList<String> ws = new ArrayList<String>();
        int i = 0;
        while (i < words.length) {
            ws.add(words[i]);
            ++i;
        }
        String predstr = "[" + XPathString.getElementContainsPredicate(ws, (String)" or ", (boolean)true, (boolean)true) + "]";
        pred = item.equals(ONLY_FILE) ? String.valueOf(pred) + XPathString.getAttributeContainsPredicate((String)"filename", ws, (String)" or ", (boolean)true) : (item.equals(ONLY_FILEINFO) ? String.valueOf(pred) + "fileinfo" + predstr : (item.equals(ALL_ITEMS) ? String.valueOf(pred) + "data" + predstr + " and " + "fileinfo" + predstr : String.valueOf(pred) + "data" + "/" + item + predstr));
        return pred;
    }

    private String getWordXPath(String str, String type, String item, String cond) {
        if (str.trim().length() == 0) {
            return "";
        }
        if (cond.equals(WordCondition.ConditionType.ALLWORDS.toString())) {
            return this.getAllWordsXPath(str, type, item);
        }
        if (cond.equals(WordCondition.ConditionType.PHRASE.toString())) {
            return this.getPhraseXPath(str, type, item);
        }
        if (cond.equals(WordCondition.ConditionType.ATLEAST.toString())) {
            return this.getAtLeastXPath(str, type, item);
        }
        if (cond.equals(WordCondition.ConditionType.NONE.toString())) {
            return this.getNoneXPath(str, type, item);
        }
        return "";
    }

    private String getDateXPath(Element info) {
        PeriodType dp = Configure.getModRangePattern(info);
        if (dp == PeriodType.NONE) {
            return "";
        }
        String pk = Configure.getModRangeStamp(info) == SearchType.CREATEDATE ? "id" : "lastmod";
        long s = 0L;
        long e = 0L;
        SearchCalendar st = new SearchCalendar();
        switch (dp) {
            case THIS_DAY: {
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case THIS_WEEK: {
                st.setLastWeekStart(0);
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setLastWeekEnd(0);
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case THIS_MONTH: {
                st.setLastMonthStart(0);
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setLastMonthEnd(0);
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case DAYS_BEFORE: {
                st.setLastDay(Configure.getModRangeSinceDate(info));
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case WEEKS_BEFORE: {
                st.setLastWeekStart(Configure.getModRangeSinceWeek(info));
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setLastWeekEnd(Configure.getModRangeSinceWeek(info));
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case MONTHS_BEFORE: {
                st.setLastMonthStart(Configure.getModRangeSinceMonth(info));
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setLastMonthEnd(Configure.getModRangeSinceMonth(info));
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case INTERVAL: {
                st = Configure.getModIntervalRangeStartDate(info);
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setToday();
                st = Configure.getModIntervalRangeEndDate(info);
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case EXACT_A_DAY: {
                st = Configure.getOneDateCalendar(info);
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case BEFORE_A_DAY: {
                s = 0L;
                st = Configure.getOneDateCalendar(info);
                st.setEndTime();
                e = st.getTimeInMillis();
                break;
            }
            case AFTER_A_DAY: {
                st = Configure.getOneDateCalendar(info);
                st.setBeginTime();
                s = st.getTimeInMillis();
                st.set(2030, 12, 31);
                e = st.getTimeInMillis();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return XPathString.getAttributeBetweenPredicate((String)pk, (String)String.valueOf(e), (String)String.valueOf(s));
    }

    private String getWordXPath(Element info) {
        ConjunctionType ct = Configure.getConjunction(info);
        String inj = "";
        inj = ct == ConjunctionType.AND ? " and " : " or ";
        String xp = "";
        ArrayList<WordCondition> wcs = Configure.getKeywords(info);
        int i = 0;
        while (i < wcs.size()) {
            WordCondition wc = wcs.get(i);
            String pp = this.getWordXPath(wc.text, wc.type, wc.item, wc.condition.toString());
            if (pp.length() != 0) {
                if (xp.length() > 0) {
                    xp = String.valueOf(xp) + inj;
                }
                xp = String.valueOf(xp) + "(" + pp + ")";
            }
            ++i;
        }
        return xp;
    }

    public String getXPath(Element info) {
        String kxp = this.getWordXPath(info);
        String dxp = this.getDateXPath(info);
        if (kxp.length() == 0 && dxp.length() == 0) {
            return "";
        }
        String xpath = "";
        xpath = kxp.length() == 0 ? dxp : (dxp.length() == 0 ? kxp : "(" + kxp + ") and (" + dxp + ")");
        System.err.println(xpath);
        return "/mdata[" + xpath + "]";
    }
}

