/**
 * Huffman.java -- Huffman
 *
 * @version $Revision: 1.18 $, $Date: 2003/03/22 02:37:57 $
 * BitInputStream, BitOutputStreamg
 */

import java.io.*;

public class Huffman {
	static final int N = 256; // At@xbg̃TCY ( = 0..N-1)
	private int heapSize, avail;
	private int[] heap = new int[2 * N - 1]; // D҂spq[v
	private int[] parent = new int[2 * N - 1]; // Huffman؂̃f[^\
	private int[] left = new int[2 * N - 1]; // V
	private int[] right = new int[2 * N - 1]; // V
	private int[] freq = new int[2 * N - 1]; // ȅopx

	/*
	 * D҂sɑ}
	 */
	private void downHeap(int i) {
		int j, k = heap[i];

		while ((j = 2 * i) <= heapSize) {
			if (j < heapSize && freq[heap[j]] > freq[heap[j + 1]])
				j++;
			if (freq[k] <= freq[heap[j]])
				break;
			heap[i] = heap[j];
			i = j;
		}
		heap[i] = k;
	}

	/*
	 * Huffman؂̏o
	 */
	private void writeTree(BitOutputStream out, int i) throws IOException {
		if (i < N) { // t
			out.putBit(false);
			out.putBits(8, i); // ̂
		} else { // 
			out.putBit(true);
			writeTree(out, left[i]); // ̎}
			writeTree(out, right[i]); // E̎}
		}
	}

	/*
	 * 
	 */
	public void encode(String infile, String outfile) throws IOException {
		int i, j, k;
		BufferedInputStream in = new BufferedInputStream(new FileInputStream(
				infile));
		BitOutputStream out = new BitOutputStream(new BufferedOutputStream(
				new FileOutputStream(outfile)));
		boolean[] codeBit = new boolean[N]; // 

		for (i = 0; i < N; i++)
			freq[i] = 0; // px̏
		while ((i = in.read()) >= 0)
			freq[i]++; // px
		heap[1] = 0; // 0̃t@Cɔ
		heapSize = 0;
		for (i = 0; i < N; i++)
			if (freq[i] != 0)
				heap[++heapSize] = i; // D҂sɓo^
		for (i = heapSize / 2; i >= 1; i--)
			downHeap(i); // q[v
		k = heap[1]; // ȉ̃[v1sȂꍇɔ
		avail = N; // ȉ̃[vHuffman؂
		while (heapSize > 1) { // 2ȏc肪
			i = heap[1]; // ŏ̗vfo
			heap[1] = heap[heapSize--];
			downHeap(1); // q[vč\
			j = heap[1]; // ɍŏ̗vfo
			k = avail++; // V߂𐶐
			freq[k] = freq[i] + freq[j]; // pxv
			heap[1] = k;
			downHeap(1); // ҂sɓo^
			parent[i] = k;
			parent[j] = -k; // ؂
			left[k] = i;
			right[k] = j; // V
		}
		parent[k] = 0; // 
		out.putBits(out.MAX_BITS, freq[k]); // ̓t@C̃oCgo
		writeTree(out, k); // ؂o
		int tableSize = out.outCount(); // \̑傫
		int inCount = 0;
		in.close(); // ŏɖ߂
		in = new BufferedInputStream(new FileInputStream(infile));
		while ((j = in.read()) >= 0) {
			k = 0;
			while ((j = parent[j]) != 0)
				if (j > 0)
					codeBit[k++] = false;
				else {
					codeBit[k++] = true;
					j = -j;
				}
			while (--k >= 0)
				out.putBit(codeBit[k]);
			if ((++inCount & 1023) == 0)
				System.err.print('.'); // 󋵕
		}
		System.err.println("\nIn : " + inCount + " bytes"); // ʕ
		System.err.println("Out: " + out.outCount() + " bytes (table: "
				+ tableSize + " bytes)");
		if (inCount != 0) { // k߂ĕ
			long cr = (1000L * out.outCount() + inCount / 2) / inCount;
			System.err.println("Out/In: " + (cr / 1000) + "." + (cr % 1000));
		}
		in.close();
		out.close(); // o̓t@CN[Y
	}

	/*
	 * Huffman؂ǂ
	 */
	private int readTree(BitInputStream in) throws IOException {
		if (in.getBit()) { // bit=1: tłȂ
			int i;
			if ((i = avail++) >= 2 * N - 1) {
				System.err.println("\ԈĂ܂");
				System.exit(-1);
			}
			left[i] = readTree(in); // ̎}ǂ
			right[i] = readTree(in); // E̎}ǂ
			return i; // ߂Ԃ
		} else
			return in.getBits(8); // 
	}

	/*
	 * 
	 */
	public void decode(String infile, String outfile) throws IOException {
		BitInputStream in = new BitInputStream(new BufferedInputStream(
				new FileInputStream(infile)));
		BufferedOutputStream out = new BufferedOutputStream(
				new FileOutputStream(outfile));
		int size = in.getBits(in.MAX_BITS); // ̃oCg
		avail = N;
		int root = readTree(in); // ؂ǂ
		for (int k = 0; k < size; k++) { // e𕜍
			int j = root; // 
			while (j >= N)
				if (in.getBit())
					j = right[j];
				else
					j = left[j];
			out.write(j);
			if ((k & 1023) == 0)
				System.err.print('.');
		}
		System.err.println("\nOut: " + size + " bytes"); // oCg
		in.close();
		out.close(); // o̓t@CN[Y
	}

	/*
	 * C
	 */
	public static void main(String[] args) throws IOException {
		Huffman huf = new Huffman();
		long time = System.currentTimeMillis();
		huf.encode("C:\\test.ppt", "C:\\test.huf");
		System.out.println(System.currentTimeMillis() - time);
	}
}

/**
 * Huffman@ȂǂŎgrbg̓[`łB
 *
 * @see BitOutputStream
 * @see Huffman
 * @see Slide
 * @see Squeeze
 */
class BitInputStream extends FilterInputStream {
	public static final int MAX_BITS = 31; // ǂݍ݉\ȍőrbg
	protected int getCount = 0; // rbg̓JE^
	protected int bitBuf = 0; // rbg̓obt@

	/**
	 * RXgN^
	 *
	 * @param in
	 *            ̓Xg[
	 */
	public BitInputStream(InputStream in) {
		super(in);
	}

	/**
	 * x ̉E n rbgԂ
	 */
	private static int rightBits(int n, int x) {
		return x & ((1 << n) - 1);
	}

	/**
	 * 1rbgǂݍ
	 */
	public boolean getBit() throws IOException {
		if (--getCount >= 0)
			return ((bitBuf >>> getCount) & 1) == 1;
		getCount = 7;
		bitBuf = in.read();
		return ((bitBuf >>> 7) & 1) == 1;
	}

	/**
	 * nrbgǂݍ
	 */
	public int getBits(int n) throws IOException {
		int x = 0;
		while (n > getCount) {
			n -= getCount;
			x |= rightBits(getCount, bitBuf) << n;
			bitBuf = in.read();
			getCount = 8;
		}
		getCount -= n;
		return x | rightBits(n, bitBuf >>> getCount);
	}
}

/**
 * Huffman@ȂǂŎgrbgo̓[`łB
 *
 * @see BitInputStream
 * @see Huffman
 * @see Slide
 * @see Squeeze
 */
class BitOutputStream extends FilterOutputStream {
	public static final int MAX_BITS = 31; // ݉\ȍőrbg
	protected int putCount = 8; // rbgo̓JE^
	protected int bitBuf = 0; // rbgo̓obt@
	protected int outCount = 0; // oCgo̓JE^

	/**
	 * RXgN^
	 *
	 * @param out
	 *            o̓Xg[
	 */
	public BitOutputStream(OutputStream out) {
		super(out);
	}

	/**
	 * o̓oCgԂ
	 */
	public int outCount() {
		return outCount;
	}

	/**
	 * x ̉E n rbgԂ
	 */
	private static int rightBits(int n, int x) {
		return x & ((1 << n) - 1);
	}

	/**
	 * 1rbgo
	 */
	public void putBit(boolean bit) throws IOException {
		putCount--;
		if (bit)
			bitBuf |= (1 << putCount);
		if (putCount == 0) {
			out.write(bitBuf);
			bitBuf = 0;
			putCount = 8;
			outCount++;
		}
	}

	/**
	 * x ̉E n rbgo
	 */
	public void putBits(int n, int x) throws IOException {
		while (n >= putCount) {
			n -= putCount;
			bitBuf |= rightBits(putCount, x >>> n);
			out.write(bitBuf);
			bitBuf = 0;
			putCount = 8;
			outCount++;
		}
		putCount -= n;
		bitBuf |= rightBits(n, x) << putCount;
	}

	/**
	 * Xg[N[Y
	 */
	public void close() throws IOException {
		putBits(7, 0);
		super.close(); // obt@tbV
	}
}
