/**
 *  2T
 *
 *  @version $Revision: 1.6 $, $Date: 2003/04/28 23:23:14 $
 */

import java.io.*;

public class BinarySearchTree {
    class Node {
        Node left, right;  String key;
        Node(Node left, Node right, String key) {
            this.left = left;  this.right = right;  this.key = key;
        }
    }

    final private Node
        zero = new Node(null, null, null),  // et̎q(Ԑlp)
        rootParent = new Node(null, zero, null);  // {\tt rootParent.right} 
    private Node parent;  private boolean isChildLeft;  // ̐e


    public boolean isEmpty() { return (rootParent.right == zero); }

    public Node searchNode(String key) {  // io^Ȃ {\tt null} Ԃj
        zero.key = key;  // {\tt zero} ͔Ԑl
        Node child = rootParent;
        int cmp = 1;  // ŏ̎q {\tt rootParent.right}
        do {
            parent = child;
            if (cmp < 0) { child = child.left;  isChildLeft = true; }
            else         { child = child.right; isChildLeft = false; }
        } while ((cmp = key.compareTo(child.key)) != 0);
        return (child == zero) ? null : child;
    }

    public Node insertNode(String key) {  // }io^j
        if (searchNode(key) != null) return null;  // łɓo^Ă

        Node newChild = new Node(zero, zero, key);
        if (isChildLeft) parent.left  = newChild;
        else             parent.right = newChild;
        return newChild;
    }

    public boolean deleteNode(String key) {  // 폜ł {\tt true} Ԃ
        final Node target = searchNode(key);
        if (target == null) return false;  // o^

        Node newChild;  // {\tt target} ̑ {\tt parent} ̎qɂȂ
        if      (target.left  == zero) newChild = target.right;
        else if (target.right == zero) newChild = target.left;
        else {
            Node s = target.left;  // {\tt s}  {\tt target} ̎ɏ̂
            if (s.right != zero) {
                Node p;  // {\tt s} ̐e
                do {  p = s;  s = s.right;  } while (s.right != zero);
                p.right = s.left;  s.left = target.left;
            }
            s.right = target.right;  newChild = s;
        }
        if (isChildLeft) parent.left  = newChild;
        else             parent.right = newChild;
        return true;  // 폜, C++ ł {\tt delete target;} Kv
    }

    public void printNode() {
        if (!isEmpty()) printNode(rootParent.right);
    }

    private int depth = 0;
    private void printNode(Node p) { // [DT,ԏŃL[\
        if (p.left != zero) {
            depth++;  printNode(p.left);  depth--;
        }
        for (int i = 0; i < depth; i++) System.out.print("     ");
        System.out.println(p.key);
        if (p.right != zero) {
            depth++;  printNode(p.right);  depth--;
        }
    }

    public static void main(String[] args) throws IOException {
        BufferedReader input =
            new BufferedReader(new InputStreamReader(System.in));
        BinarySearchTree tree = new BinarySearchTree();

        System.out.print(" Iabc:  abc}\n"
                       + "     Dabc:  abc폜\n"
                       + "     Sabc:  abc\n");
        for ( ; ; ) {
            System.out.print("? ");
            String s = input.readLine();
            if (s == null) break;
            if (s.length() <= 1) s = "help";
            String key = s.substring(1),  message;
            switch (Character.toUpperCase(s.charAt(0))) {
            case 'I':
                if (tree.insertNode(key) != null)
                     message = "o^܂.";
                else message = "o^݂ł.";
                break;
            case 'D':
                if (tree.deleteNode(key))
                     message = "폜܂.";
                else message = "o^Ă܂.";
                break;
            case 'S':
                if (tree.searchNode(key) != null)
                     message = "o^Ă܂.";
                else message = "o^Ă܂";
                break;
            default:
                message = "ĝ I, D, S ł.";
                break;
            }
            System.out.println(message);  tree.printNode();
        }
    }
}
