/**
 *  B
 *
 *  @version $Revision: 1.7 $, $Date: 2003/04/28 23:23:14 $
 */

import java.io.*;

public class BTree {
    private static final int M = 2;  // 1y[W̃f[^̏̔
    private int insertKey;  private Page insertPage;  // }p
    private boolean undersize;  // 폜p

    private class Page {
        int n = 0;                            // f[^
        int[] key = new int[2 * M];           // L[
        Page[] branch = new Page[2 * M + 1];  // y[Wւ̃|C^

        /** ؂ċAIɂǂ \texttt{searchKey} T */
        private boolean searchNode(int searchKey) {
            int i = 0;
            while (i < n && key[i] < searchKey) i++;
            if (i < n && key[i] == searchKey) return true;
            if (branch[i] == null) return false;
            return branch[i].searchNode(searchKey);
        }

        /** \texttt{newKey}  \texttt{key[i]} ɁC
            \texttt{newPage}  \texttt{branch[i + 1]} ɑ} */
        private void insertItem(int i, int newKey, Page newPage) {
            for (int j = n; j > i; j--) {
                branch[j + 1] = branch[j];
                key[j] = key[j - 1];
            }
            key[i] = newKey;  branch[i + 1] = newPage;  n++;
        }

        /** \texttt{insertKey}  \texttt{key[i]} ɑ}C̃y[W */
        private void split(int i) {
            final int m;
            if (i <= M) m = M;  else m = M + 1;
            Page q = new Page();
            for (int j = m + 1; j <= 2 * M; j++) {
                q.key[j - m - 1] = key[j - 1];
                q.branch[j - m] = branch[j];
            }
            q.n = 2 * M - m;  n = m;
            if (i <= M) insertItem(i, insertKey, insertPage);
            else      q.insertItem(i - m, insertKey, insertPage);
            insertKey = key[n - 1];
            q.branch[0] = branch[n];  n--;
            insertPage = q;
        }

        /** ؂ċAIɂǂ \texttt{insertKey} } */
        private boolean insertNode() {
            int i = 0;
            while (i < n && key[i] < insertKey) i++;
            if (i < n && key[i] == insertKey) {
                message = "o^Ă܂";  return true;
            }
            if (branch[i] != null && branch[i].insertNode())
                return true;
            if (n < 2 * M) {  // y[WȂꍇ
                insertItem(i, insertKey, insertPage);  return true;
            } else {         // y[Wꍇ
                split(i);  return false;
            }
        }

        /** \texttt{key[i]}, \texttt{branch[i+1]} OC
            y[WȂ肷 \texttt{undersize} tO𗧂Ă */
        private void deleteItem(int i) {
            while (++i < n) {
                key[i - 1] = key[i];
                branch[i] = branch[i + 1];
            }
            branch[n] = null;
            undersize = (--n < M);
        }

        /** \texttt{branch[i - 1]} ̍ŉEvf
            \texttt{key[i - 1]} oR \texttt{branch[i]} ɓ */
        private void moveRight(int i) {
            Page left = branch[i - 1],  right = branch[i];
            right.insertItem(0, key[i - 1], right.branch[0]);
            key[i - 1] = left.key[left.n - 1];
            right.branch[0] = left.branch[left.n];
            left.n--;  // \texttt{left.deleteItem(left.n)} Ɠ
        }

        /** \texttt{branch[i]} ̍ōvf
            \texttt{key[i - 1]} oR \texttt{branch[i - 1]} ɓ */
        private void moveLeft(int i) {
            Page left = branch[i - 1],  right = branch[i];
            left.insertItem(left.n, key[i - 1], right.branch[0]);
            key[i - 1] = right.key[0];
            right.branch[0] = right.branch[1];
            right.deleteItem(0);
        }

        /** \texttt{branch[i - 1]}, \texttt{branch[i]}  */
        private void combine(int i) {
            Page left = branch[i - 1],  right = branch[i];
            left.insertItem(left.n, key[i - 1], right.branch[0]);
            for (int j = 1; j <= right.n; j++)
                left.insertItem(left.n,
                                right.key[j - 1], right.branch[j]);
            deleteItem(i - 1);  // C++ ł {\tt delete right;} Kv
        }

        /** Ȃ肷y[W \texttt{branch[i]} C */
        private void restore(int i) {
            undersize = false;
            if (i > 0) {
                if (branch[i - 1].n > M) moveRight(i);
                else combine(i);
            } else {
                if (branch[1].n > M) moveLeft(1);
                else combine(1);
            }
        }

        /** ċAIɖ؂ǂ \texttt{deleteKey} 폜 */
        private boolean deleteNode(int deleteKey) {
            int i = 0;  boolean deleted = false;
            while (i < n && key[i] < deleteKey) i++;
            if (i < n && key[i] == deleteKey) {  // 
                deleted = true;
                Page q = branch[i + 1];
                if (q != null) {
                    while (q.branch[0] != null) q = q.branch[0];
                    key[i] = deleteKey = q.key[0];
                    branch[i + 1].deleteNode(deleteKey);
                    if (undersize) restore(i + 1);
                } else deleteItem(i);
            } else {
                if (branch[i] != null) {
                    deleted = branch[i].deleteNode(deleteKey);
                    if (undersize) restore(i);
                }
            }
            return deleted;
        }

        /** ċAIɖ؂ǂ\ */
        private void print() {
            System.out.print("(");
            for (int i = 0; i <= n; i++) {
                if (branch[i] == null) System.out.print(".");
                else branch[i].print();  // ċAďo
                if (i < n) System.out.print(key[i]);
            }
            System.out.print(")");
        }
    }

    private Page root = new Page();        // B؂̍
    static String message = "";            // ֐̕ԂbZ[W

    /** L[ \texttt{key} B؂T */
    public void searchNode(int key) {
        if (root.searchNode(key)) message = "܂";
        else                      message = "܂";
    }

    /** L[ \texttt{key} B؂ɑ} */
    public void insertNode(int key) {
        message = "o^܂";
        insertKey = key;  insertPage = null;
        if (root != null && root.insertNode()) return;
        Page p = new Page();  p.branch[0] = root;  root = p;
        p.insertItem(0, insertKey, insertPage);
    }

    /** L[ \texttt{key} B؂O */
    public void deleteNode(int key)  {
        undersize = false;
        if (root.deleteNode(key)) {  // ċAIɖ؂ǂ폜
            if (root.n == 0) {  // ɂȂꍇ
                /* Page p = root; */
                root = root.branch[0];  /* delete p; */
            }  // C++ ł {\tt /*..*/} ̏Kv
            message = "폜܂";
        } else message = "܂";
    }

    /** fpBؑŜ\ */
    public void print() {
        if (root != null) root.print();  else System.out.print(".");
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        BufferedReader input =
            new BufferedReader(new InputStreamReader(System.in));
        BTree tree = new BTree();

        for ( ; ; ) {
            System.out.print("} In,  Sn, 폜 Dn (n:)? ");
            String s = input.readLine();
            if (s == null) break;
            int key = Integer.parseInt(s.substring(1));
            switch (Character.toUpperCase(s.charAt(0))) {
            case 'I':  tree.insertNode(key);  break;
            case 'S':  tree.searchNode(key);  break;
            case 'D':  tree.deleteNode(key);  break;
            default :  message = "???";   break;
            }
            System.out.println(message);
            tree.print();
        }
    }
}
