from parser import *
import re
import sys
import symbol
import token
import types

def escapeElementValue(value):
	value = re.sub("&", "&amp;", value)
	value = re.sub("<", "&lt;", value)
	value = re.sub(">", "&gt;", value)
	return value

def printAst(tuple):
	printAst2(tuple, 0, 1)

def printAst2(tuple, depth, lastline):
	id = tuple[0]
	if not isinstance(tuple[1], types.StringType):
		element_name = symbol.sym_name[id]
		print ("  " * depth + "<" + element_name + ">")
		for item in tuple[1:]:
			lastline = printAst2(item, depth + 1, lastline)
		print ("  " * depth + "</" + element_name + ">")
	else:
		element_name = token.tok_name[id]
		print ("  " * depth + "<" + element_name + " startline=\"" + str(lastline) + "\" endline=\"" + str(tuple[2]) + "\">" + escapeElementValue(tuple[1]) + "</" + element_name + ">")
		lastline = tuple[2]
		if element_name == "NEWLINE": lastline += 1
	return lastline

ast = suite(sys.stdin.read())
printAst(ast2tuple(ast, True))
