package covman;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashSet;

public final class CovMan {
	private static HashSet<String> executedStatements = new HashSet<String>();
	private static HashSet<String> trueBranches = new HashSet<String>();
	private static HashSet<String> falseBranches = new HashSet<String>();
	
	static {
		Runtime.getRuntime().addShutdownHook(new Thread() {
			@Override
			public void run() {
				PrintStream out;
				try {
					out = new PrintStream("coverage_result.txt");
				} catch (FileNotFoundException e) {
					e.printStackTrace();
					out = System.out;
				}
				
				for (String key : executedStatements) {
					out.println("3" + "," + key);
				}
				for (String key : trueBranches) {
					out.println("1" + "," + key);
				}
				for (String key : falseBranches) {
					out.println("2" + "," + key);
				}
			}
		});
	}
	
	public static boolean branch(String key, boolean value) {
		if (value)
			trueBranches.add(key);
		else
			falseBranches.add(key);
		return value;
	}
	
	public static void statement(String key) {
		executedStatements.add(key);
	}
}
