﻿using System.Collections.Generic;
using System.Linq;
using CoverageFramework.Operator.Selector;
using Paraiba.Linq;

namespace CoverageFramework.Utility
{
	public static class XElementSelectorUtil
	{
		public static IXElementSelector Merge(IEnumerable<IXElementSelector> selectors)
		{
			return new XElementSelectorUnion(selectors);
		}

		public static IXElementSelector Merge(params IXElementSelector[] selectors)
		{
			return Merge((IEnumerable<IXElementSelector>)selectors);
		}

		public static IXElementRangeSelector Merge(IEnumerable<IXElementRangeSelector> rangeSelectors)
		{
			return new XElementRangeSelectorUnion(rangeSelectors);
		}

		public static IXElementRangeSelector Merge(params IXElementRangeSelector[] rangeSelectors)
		{
			return Merge((IEnumerable<IXElementRangeSelector>)rangeSelectors);
		}

		public static IXElementSelector Chain(IEnumerable<IXElementSelector> selectors)
		{
			return selectors.Aggregate((current, next) => new XElementSelectorPipe(current, next));
		}

		public static IXElementSelector Chain(params IXElementSelector[] rangeSelectors)
		{
			return Chain((IEnumerable<IXElementSelector>)rangeSelectors);
		}

		public static IXElementRangeSelector Chain(IEnumerable<IXElementRangeSelector> rangeSelectors)
		{
			return rangeSelectors.Aggregate((current, next) => new XElementRangeSelectorPipe(current, next));
		}

		public static IXElementRangeSelector Chain(params IXElementRangeSelector[] rangeSelectors)
		{
			return Chain((IEnumerable<IXElementRangeSelector>)rangeSelectors);
		}
	}
}