using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector
{
	public class XElementSelectorPipe : IXElementSelector
	{
		private readonly IXElementSelector _next;
		private readonly IXElementSelector _prev;

		public XElementSelectorPipe(IXElementSelector prev, IXElementSelector next)
		{
			_prev = prev;
			_next = next;
		}

		#region IXElementSelector o

		public IEnumerable<XElement> Select(XElement root)
		{
			return _prev.Select(root).SelectMany(e => _next.Select(e));
		}

		#endregion
	}
}