using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector
{
	public class XElementRangeSelectorPipe : IXElementRangeSelector
	{
		private readonly IXElementRangeSelector _next;
		private readonly IXElementRangeSelector _prev;

		public XElementRangeSelectorPipe(IXElementRangeSelector prev, IXElementRangeSelector next)
		{
			_prev = prev;
			_next = next;
		}

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			return _prev.Select(root)
				.SelectMany(block =>
					block.SelectMany(e => _next.Select(e)));
		}

		#endregion
	}
}