﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.Python3
{
	[Export(typeof(IXElementSelector))]
	public class CompoundStatementSelector : IXElementSelector
	{
		private static readonly string[] StatementNames = {
			"if_stmt",
			"while_stmt",
			"for_stmt",
			"with_stmt",
		};

		public IEnumerable<XElement> Select(XElement root)
		{
			return root.Descendants()
				.Where(e => StatementNames.Any(e.Name.LocalName.EndsWith));
		}
	}
}
