using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

namespace CoverageFramework.Operator.Selector.Python
{
	public class IfConditionExpressionSelectorForPython : IXElementRangeSelector
	{
		private static readonly string[] _ifNames = new[] {
			"if_stmt",
		};

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			// Zq (exp1 if cond else exp2) <=> (cond ? exp1 : exp2)
			// Xg\L [ x * x for x in list if x > 0 ] XgԂ
			// WFl[^[ ( x * x for x in list if x > 0 ) WFl[^[(Iterable)Ԃ

			return root
				// SĂifvf
				.Descendants()
				.Where(e_ => _ifNames.Contains(e_.Name.LocalName))
				// if̏Ɏˉe
				.Select(e_ => e_.Elements()
					.SkipWhile(e2_ => !(!e2_.HasElements && (e2_.Value == "if" || e2_.Value == "elif")))
					.Skip(1)
					.TakeWhile(e2_ => e2_.Name.LocalName != "COLON"))
				.Where(block_ => !block_.IsEmpty());
		}

		#endregion
	}
}