using System.Linq;
using System.Xml.Linq;
using System.ComponentModel.Composition;

namespace CoverageFramework.Operator.Selector.Python
{
	[Export(typeof(IXElementRangeSelector))]
	public class AtomicBooleanTermSelectorForPython : AtomicBooleanTermSelector
	{
		private static readonly string[] _condComponentNames = new[] {
			"or_test",
			"and_test",
		};

		private static readonly string[] _condNames = new[] {
			"or_test",
			"and_test",
		};

		private static readonly string[] _condOpValues = new[] {
			"or",
			"and",
		};

		protected override bool IsBoolTermSepartor(XElement element)
		{
			return !element.HasElements && _condOpValues.Contains(element.Value);
		}

		protected override bool IsConditionalExpression(XElement element)
		{
			return _condNames.Contains(element.Name.LocalName);
		}

		protected override bool IsConditionalExpressionComponent(XElement element)
		{
			return _condComponentNames.Contains(element.Name.LocalName);
		}
	}
}