﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.Java2
{
	[Export(typeof(IXElementSelector))]
	public class StatementSelector : IXElementSelector
	{
		private static readonly string[] StatementNames = {
			// If
			"IfThenStatement",
			"IfThenElseStatement",
			"IfThenElseStatementNoShortIf",
			// For
			"BasicForStatement",
			"EnhancedForStatement",
			"ForStatementNoShortIf",
			// While
			"WhileStatement",
			"WhileStatementNoShortIf",
			// StatementWithoutTrailingSubstatement
            //"Block",
			"EmptyStatement",
			"ExpressionStatement",
			"AssertStatement",
            "SwitchStatement",
			"DoStatement",
			"BreakStatement",
			"ContinueStatement",
			"ReturnStatement",
			"SynchronizedStatement",
			"ThrowStatement",
			//"TryStatement",
			// BlockStatement
            "LocalVariableDeclarationStatement",
		};

		public IEnumerable<XElement> Select(XElement root)
		{
			return root.Descendants()
				.Where(e => StatementNames.Any(e.Name.LocalName.EndsWith));
		}
	}
}
