﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.Java2
{
	[Export(typeof(IXElementSelector))]
	public class IfConditionSelector : XElementSelector
	{
		private static readonly string[] IfStatementNames = {
			// If
			"IfThenStatement",
			"IfThenElseStatement",
			"IfThenElseStatementNoShortIf",
		};

		protected override IEnumerable<XElement> SelectContainingNull(XElement root)
		{
			var ifStatements = root.Descendants()
				.Where(e => IfStatementNames.Any(e.Name.LocalName.EndsWith));
			return ifStatements.Select(e => e.Elements().ElementAtOrDefault(2));
		}
	}
}
