﻿using System.ComponentModel.Composition;
using System.Linq;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.Java2
{
	[Export(typeof(IXElementSelector))]
	public class ConditionalTermSelector : AtomicConditionalTermSelector
	{
		private static readonly string[] TargetNames = {
			"ConditionalAndExpression", "InclusiveOrExpression",
		};
		private static readonly string[] ParentNames = {
			"ArgumentList", "ArrayAccess",
		};
		protected override bool IsConditionalTerm(XElement element)
		{
			return TargetNames.Any(element.Name.LocalName.EndsWith);
		}
		protected override bool IsAllowableParent(XElement element)
		{
			return !ParentNames.Any(element.Name.LocalName.EndsWith);
		}
	}
}
