using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

namespace CoverageFramework.Operator.Selector.Java
{
	public class SwitchSelectorForJava : IXElementRangeSelector
	{
		private static readonly string[] _switchNames = new[] {
			"SwitchStatement",
		};

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			return root
				// SĂswitchvf
				.Descendants()
				.Where(e_ => _switchNames.Any(e_.Name.LocalName.EndsWith))
				.Select(e_ => e_.ToEnumerable());
		}

		#endregion
	}
}