﻿using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using CoverageFramework.Utility;

namespace CoverageFramework.Operator.Selector.Java
{
	public class LackingBlockStatementSelectorForJava : IXElementRangeSelector
	{
		#region IXElementRangeSelector メンバ

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			var ifSelector = XElementSelectorUtil.Chain(
				new IfSelectorForJava(),
				new IfElseStatementSelectorForJava());

			var whileForForEachSelector = XElementSelectorUtil.Chain(
				XElementSelectorUtil.Merge(
					new WhileSelectorForJava(),
					new ForSelectorForJava(),
					new ForEachSelectorForJava()),
				new ForWhileStatementSelectorForJava());

			var doWhileSelector = XElementSelectorUtil.Chain(
				new DoWhileSelectorForJava(),
				new DoWhileStatementSelectorForJava());

			return XElementSelectorUtil.Merge(ifSelector, whileForForEachSelector, doWhileSelector)
				.Select(root)
				.Where(block_ => block_.First().Name.LocalName != "ABlock");
		}

		#endregion
	}
}