using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

namespace CoverageFramework.Operator.Selector.Java
{
	public class IfElseStatementSelectorForJava : IXElementRangeSelector
	{
		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			var targetSource = root
				.Elements()
				.SkipWhile(e_ => e_.Name.LocalName != "TRPar")
				.Skip(1);
			{
				var result = targetSource
					.Take(1);
				if (!result.IsEmpty())
					yield return result;
			}

			{
				var result = targetSource
					.SkipWhile(e_ => e_.Name.LocalName != "TElse")
					.Skip(1)
					.Take(1);
				if (!result.IsEmpty())
					yield return result;
			}
		}

		#endregion
	}
}