using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;

namespace CoverageFramework.Operator.Selector.Java
{
	public abstract class ControlFlowSelectorForJava : IXElementRangeSelector
	{
		private readonly string[] _names;

		protected ControlFlowSelectorForJava(string[] names)
		{
			_names = names;
		}

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			yield return root
				// SĂifvf
				.Descendants()
				.Where(e_ => _names.Any(e_.Name.LocalName.EndsWith));
		}

		#endregion
	}
}