using System.Linq;
using System.Xml.Linq;
using System.ComponentModel.Composition;

namespace CoverageFramework.Operator.Selector.Java
{
	[Export(typeof(IXElementRangeSelector))]
	public class AtomicBooleanTermSelectorForJava : AtomicBooleanTermSelector
	{
		private static readonly string[] CondComponentNames = new[] {
			"ConditionalOrExpression",
			"ConditionalAndExpression",
			"PrimaryNoNewArray", // ʂŊƏo(AExpressionPrimaryNoNewArray)
		};

		private static readonly string[] CondNames = new[] {
			"ConditionalOrExpression",
			"ConditionalAndExpression",
		};

		private static readonly string[] CondOpNames = new[] {
			"TBarBar",
			"TAmpAmp",
		};

		protected override bool IsBoolTermSepartor(XElement element)
		{
			return CondOpNames.Contains(element.Name.LocalName);
		}

		protected override bool IsConditionalExpression(XElement element)
		{
			return CondNames.Any(element.Name.LocalName.EndsWith);
		}

		protected override bool IsConditionalExpressionComponent(XElement element)
		{
			return CondComponentNames.Any(element.Name.LocalName.EndsWith);
		}
	}
}