using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

namespace CoverageFramework.Operator.Selector.C
{
	public class SwitchSelectorForC : IXElementRangeSelector
	{
		private static readonly string[] _switchNames = new[] {
			"selection_statement",
		};

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			return root
				// SĂswitchvf
				.Descendants()
				.Where(e_ => _switchNames.Contains(e_.Name.LocalName))
				.Where(e_ => {
					// if̏
					var e2_ = e_.Elements().FirstOrDefault();
					return e2_ != null && !e2_.HasElements && e2_.Value == "switch";
				})
				.Select(e_ => e_.ToEnumerable());
		}

		#endregion
	}
}