using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;
using Paraiba.Xml.Linq;

namespace CoverageFramework.Operator.Selector.C
{
	public class SwitchCaseSelectorForC : IXElementRangeSelector
	{
		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			return root
				.Descendants("labeled_statement")
				// switch̃lXg΍
				.Where(e_ => e_.Parents()
					.TakeWhile(e2_ => !ReferenceEquals(e2_, root))
					.All(e2_ => e2_.Name.LocalName != "selection_statement"))
				.Where(e_ => {
					var e2_ = e_.Elements().FirstOrDefault();
					return e2_ != null && !e2_.HasElements && e2_.Value == "case";
				})
				.Select(e_ => e_.Elements().TakeWhileWithNext(e2_ => !(!e2_.HasElements && e2_.Value == ":")))
				.Where(block_ => !block_.IsEmpty());
		}

		#endregion
	}
}