using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using Paraiba.Linq;

namespace CoverageFramework.Operator.Selector
{
	public class AtomicStatementSelector : IXElementRangeSelector
	{
		protected virtual bool IsStatementElement(XElement element)
		{
			return element.Name.LocalName.ToLower().EndsWith("statement");
		}

		protected virtual bool IsStatementSepartor(XElement element)
		{
			return false;
		}

		#region IXElementRangeSelector o

		public IEnumerable<IEnumerable<XElement>> Select(XElement root)
		{
			return root.Descendants()
				.Where(IsStatementElement)
				.Where(e_ => !e_.Descendants().Any(IsStatementElement))
				.SelectMany(e_ => e_.Elements().SplitWithoutEmpty(IsStatementSepartor))
				.Cast<IEnumerable<XElement>>();
		}

		#endregion
	}
}