using System.Xml.Linq;

namespace CoverageFramework.Operator.Generator
{
	public interface ITaggedXElementGenerator
	{
		XElement[] Generate(string tag);
	}

	public interface ITaggedXElementGeneratorFactory
	{
		ITaggedXElementGenerator GetInstance();
	}

	public abstract class TaggedXElementGeneratorFactory : ITaggedXElementGeneratorFactory
	{
		private ITaggedXElementGenerator _instance;

		protected abstract ITaggedXElementGenerator CreateInstance();

		#region ITaggedXElementGeneratorFactory o

		public ITaggedXElementGenerator GetInstance()
		{
			if (_instance == null)
			{
				_instance = CreateInstance();
			}
			return _instance;
		}

		#endregion
	}
}