﻿using System.Linq;
using System.Xml.Linq;
using CoverageFramework.Operator.Decorator;
using CoverageFramework.Operator.Selector;

namespace CoverageFramework.Embedder
{
	public class BlockEmbedder
	{
		public void Reform(XDocument doc, IXElementRangeSelector rangeSelector, IXElementDecorator blockDec)
		{
			foreach (var target in rangeSelector.Select(doc.Root).ToList())
			{
				// 先に削除を行うため，リストにしておく
				var targetList = target.ToList();

				// 直前に要素があるかどうか調べる
				var prev = targetList[0].PreviousNode;
				if (prev != null)
				{
					// 要素の複製防止のために削除して，同じ位置に挿入し直す
					targetList.Remove();
					prev.AddAfterSelf(blockDec.Generate(targetList));
				}
				else
				{
					var parent = targetList[0].Parent;
					// 要素の複製防止のために削除して，同じ位置に挿入し直す
					targetList.Remove();
					parent.AddFirst(blockDec.Generate(targetList));
				}
			}
		}
	}
}