﻿using System.Xml.Linq;
using System.ComponentModel.Composition;

namespace CoverageFramework.CodeGenerator.C
{
	[Export(typeof(ISourceCodeGenerator))]
	public class SourceCodeGeneratorForC : SourceCodeGenerator
	{
		protected override bool TreatTerminalSymbol(XElement element)
		{
			switch (element.Value)
			{
			case ";":
				WriteLine(";");
				break;

			case "{":
				WriteLine("{");
				Depth++;
				break;

			case "}":
				Depth--;
				WriteLine("}");
				break;

			default:
				return false;
			}

			return true;
		}
	}
}