/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;

public class BuildDependencyGenerator {
    protected String grammarFileName;
    protected Tool tool;
    protected Grammar grammar;
    protected CodeGenerator generator;
    protected StringTemplateGroup templates;

    public BuildDependencyGenerator(Tool tool, String string) throws IOException, TokenStreamException, RecognitionException {
        this.tool = tool;
        this.grammarFileName = string;
        this.grammar = tool.getRootGrammar(string);
        String string2 = (String)this.grammar.getOption("language");
        this.generator = new CodeGenerator(tool, this.grammar, string2);
        this.generator.loadTemplates(string2);
    }

    public List getGeneratedFileList() {
        String string;
        Object object;
        Object object2;
        List<Grammar> list;
        String string2;
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = this.tool.getOutputDirectory(this.grammarFileName);
        if (file.getName().equals(".")) {
            file = null;
        } else if (file.getName().indexOf(32) >= 0) {
            string2 = Utils.replace(file.toString(), " ", "\\ ");
            file = new File(string2);
        }
        string2 = this.generator.getRecognizerFileName(this.grammar.name, this.grammar.type);
        arrayList.add(new File(file, string2));
        arrayList.add(new File(file, this.generator.getVocabFileName()));
        StringTemplate stringTemplate = null;
        if (this.generator.getTemplates().isDefined("headerFile")) {
            stringTemplate = this.generator.getTemplates().getInstanceOf("headerFileExtension");
            list = Grammar.grammarTypeToFileNameSuffix[this.grammar.type];
            object2 = this.grammar.name + list + stringTemplate.toString();
            arrayList.add(new File(file, (String)object2));
        }
        if (this.grammar.type == 4) {
            list = this.generator.getTemplates().getInstanceOf("codeFileExtension");
            object2 = Grammar.grammarTypeToFileNameSuffix[1];
            object = this.grammar.name + (String)object2 + ((StringTemplate)((Object)list)).toString();
            arrayList.add(new File(file, (String)object));
            if (stringTemplate != null) {
                string = this.grammar.name + (String)object2 + stringTemplate.toString();
                arrayList.add(new File(file, string));
            }
        }
        list = this.grammar.composite.getDelegates(this.grammar.composite.getRootGrammar());
        object2 = list.iterator();
        while (object2.hasNext()) {
            object = (Grammar)object2.next();
            file = this.tool.getOutputDirectory(((Grammar)object).getFileName());
            string = this.groomQualifiedFileName(file.toString(), ((Grammar)object).getRecognizerName());
            arrayList.add(new File(string));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public List getDependenciesFileList() {
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = (String)this.grammar.getOption("tokenVocab");
        if (string != null) {
            object3 = this.tool.getImportedVocabFile(string);
            object2 = ((File)object3).getParentFile();
            object = this.groomQualifiedFileName(((File)object2).getName(), ((File)object3).getName());
            arrayList.add((String)object);
        }
        object3 = this.grammar.composite.getDelegates(this.grammar.composite.getRootGrammar());
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (Grammar)object2.next();
            String string2 = this.tool.getLibraryDirectory();
            String string3 = this.groomQualifiedFileName(string2, ((Grammar)object).fileName);
            arrayList.add(string3);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public StringTemplate getDependencies() {
        this.loadDependencyTemplates();
        StringTemplate stringTemplate = this.templates.getInstanceOf("dependencies");
        stringTemplate.setAttribute("in", this.getDependenciesFileList());
        stringTemplate.setAttribute("out", this.getGeneratedFileList());
        stringTemplate.setAttribute("grammarFileName", this.grammar.fileName);
        return stringTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDependencyTemplates() {
        if (this.templates != null) {
            return;
        }
        String string = "org/antlr/tool/templates/depend.stg";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            classLoader = ErrorManager.class.getClassLoader();
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            ErrorManager.internalError("Can't load dependency templates: " + string);
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.templates = new StringTemplateGroup((Reader)bufferedReader, AngleBracketTemplateLexer.class);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            ErrorManager.internalError("error reading dependency templates file " + string, iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    ErrorManager.internalError("cannot close dependency templates file " + string, iOException);
                }
            }
        }
    }

    public String groomQualifiedFileName(String string, String string2) {
        if (string.equals(".")) {
            return string2;
        }
        if (string.indexOf(32) >= 0) {
            String string3 = Utils.replace(string.toString(), " ", "\\ ");
            return string3 + File.separator + string2;
        }
        return string + File.separator + string2;
    }
}

