using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;
using System.Security;
using mshtml;

namespace Alternative.Win32
{
	#region Structs

	[Serializable, StructLayout(LayoutKind.Sequential)]
	public struct MSG
	{
		public IntPtr hwnd;
		public int message;
		public IntPtr wParam;
		public IntPtr lParam;
		public int time;
		public int pt_x;
		public int pt_y;
	}
	[StructLayout(LayoutKind.Sequential)]
	public struct tagMSG
	{
		public IntPtr hwnd;
		public uint message;
		public IntPtr wParam;
		public IntPtr lParam;
		public uint time;
		public mshtml.tagPOINT pt;
	}


	[StructLayout(LayoutKind.Sequential)]
	public struct POINT
	{
		public int x;
		public int y;
		public POINT(int x, int y) { this.x = x; this.y = y; }
	}
	[StructLayout(LayoutKind.Sequential)]
	public struct tagPOINTF
	{
		[MarshalAs(UnmanagedType.R4)]
		public float x;
		[MarshalAs(UnmanagedType.R4)]
		public float y;
	}
	[StructLayout(LayoutKind.Sequential)]
	public struct _POINTL
	{
		public int x;
		public int y;
	}

	[StructLayout(LayoutKind.Sequential)]
	public struct tagSIZEL
	{
		public int cx;
		public int cy;
	}

	[StructLayout(LayoutKind.Sequential)]
	public struct COMRECT
	{
		public int left;
		public int top;
		public int right;
		public int bottom;

		public COMRECT(System.Drawing.Rectangle r)
		{
			left = r.Left;
			top = r.Top;
			right = r.Right;
			bottom = r.Bottom;
		}
		public COMRECT(int left, int top, int right, int bottom)
		{
			this.left = left;
			this.top = top;
			this.right = right;
			this.bottom = bottom;
		}
		public static COMRECT FromXYWH(int x, int y, int width, int height)
		{
			return new COMRECT(x, y, x + width, y + height);
		}
		public override string ToString()
		{
			return String.Format("X={0},Y={1},W={2},H={3}", this.left, this.top, this.right - this.left, this.bottom - this.top);
		}
	}


	[StructLayout(LayoutKind.Sequential)]
	public struct OLECMD
	{
		public long cmdID;
		public ulong cmdf;
	}
	[StructLayout(LayoutKind.Sequential)]
	public struct OLECMDTEXT
	{
		public uint cmdtextf;
		public uint cwActual;
		public uint cwBuf;
		public char rgwz;
	}
	[StructLayout(LayoutKind.Sequential)]
	public struct tagOLEVERB
	{
		public int lVerb;
		[MarshalAs(UnmanagedType.LPWStr)]
		public string lpszVerbName;
		[MarshalAs(UnmanagedType.U4)]
		public int fuFlags;
		[MarshalAs(UnmanagedType.U4)]
		public int grfAttribs;
	}

	[StructLayout(LayoutKind.Sequential)]
	public struct tagOleMenuGroupWidths
	{
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 6)]
		public int[] widths;
	}


	[StructLayout(LayoutKind.Sequential)]
	public struct tagOIFI
	{
		[MarshalAs(UnmanagedType.U4)]
		public int cb;
		public bool fMDIApp;
		public IntPtr hwndFrame;
		public IntPtr hAccel;
		[MarshalAs(UnmanagedType.U4)]
		public int cAccelEntries;
	}
	[StructLayout(LayoutKind.Sequential)]
	public struct tagLOGPALETTE
	{
		[MarshalAs(UnmanagedType.U2)]
		public short palVersion;
		[MarshalAs(UnmanagedType.U2)]
		public short palNumEntries;
	}

	#endregion

	public delegate IntPtr WindowProcDelegate(IntPtr hWnd, int message, IntPtr wParam, IntPtr mParam);

}
