using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Globalization;

namespace Alternative.Win32
{
	[StructLayout(LayoutKind.Sequential)]
	public struct VARIANT
	{
		[MarshalAs(UnmanagedType.I2)]
		public short vt;
		[MarshalAs(UnmanagedType.I2)]
		public short reserved1;
		[MarshalAs(UnmanagedType.I2)]
		public short reserved2;
		[MarshalAs(UnmanagedType.I2)]
		public short reserved3;
		public IntPtr data1;
		public IntPtr data2;


		public bool Byref
		{
			get { return (this.vt & 0x4000) != 0; }
		}

		public void Clear()
		{
			if(((this.vt == 13) || (this.vt == 9)) && (this.data1 != IntPtr.Zero))
			{
				Marshal.Release(this.data1);
			}
			if((this.vt == 8) && (this.data1 != IntPtr.Zero))
			{
				SysFreeString(this.data1);
			}
			this.data1 = this.data2 = IntPtr.Zero;
			this.vt = 0;
		}

		[DllImport("oleaut32.dll", CharSet = CharSet.Auto)]
		private static extern IntPtr SysAllocString([In, MarshalAs(UnmanagedType.LPWStr)] string s);
		[DllImport("oleaut32.dll", CharSet = CharSet.Auto)]
		private static extern void SysFreeString(IntPtr pbstr);


		public void SetLong(long lVal)
		{
			this.data1 = (IntPtr)(((ulong)lVal) & 0xffffffffL);
			this.data2 = (IntPtr)(((ulong)(lVal >> 0x20)) & 0xffffffffL);
		}

		public IntPtr ToCoTaskMemPtr()
		{
			IntPtr ptr = Marshal.AllocCoTaskMem(0x10);
			Marshal.WriteInt16(ptr, this.vt);
			Marshal.WriteInt16(ptr, 2, this.reserved1);
			Marshal.WriteInt16(ptr, 4, this.reserved2);
			Marshal.WriteInt16(ptr, 6, this.reserved3);
			Marshal.WriteInt32(ptr, 8, (int)this.data1);
			Marshal.WriteInt32(ptr, 12, (int)this.data2);
			return ptr;
		}


		public static VARIANT FromObject(object var)
		{
			VARIANT variant = new VARIANT();
			if(var == null)
			{
				variant.vt = 0;
				return variant;
			}
			if(!Convert.IsDBNull(var))
			{
				Type type = var.GetType();
				if(type == typeof(bool))
				{
					variant.vt = 11;
					return variant;
				}
				if(type == typeof(byte))
				{
					variant.vt = 0x11;
					variant.data1 = (IntPtr)Convert.ToByte(var, CultureInfo.InvariantCulture);
					return variant;
				}
				if(type == typeof(char))
				{
					variant.vt = 0x12;
					variant.data1 = (IntPtr)Convert.ToChar(var, CultureInfo.InvariantCulture);
					return variant;
				}
				if(type == typeof(string))
				{
					variant.vt = 8;
					variant.data1 = SysAllocString(Convert.ToString(var, CultureInfo.InvariantCulture));
					return variant;
				}
				if(type == typeof(short))
				{
					variant.vt = 2;
					variant.data1 = (IntPtr)Convert.ToInt16(var, CultureInfo.InvariantCulture);
					return variant;
				}
				if(type == typeof(int))
				{
					variant.vt = 3;
					variant.data1 = (IntPtr)Convert.ToInt32(var, CultureInfo.InvariantCulture);
					return variant;
				}
				if(type == typeof(long))
				{
					variant.vt = 20;
					variant.SetLong(Convert.ToInt64(var, CultureInfo.InvariantCulture));
					return variant;
				}
				if(type == typeof(decimal))
				{
					variant.vt = 6;
					decimal d = (decimal)var;
					variant.SetLong(decimal.ToInt64(d));
					return variant;
				}
				if(type == typeof(decimal))
				{
					variant.vt = 14;
					decimal num2 = Convert.ToDecimal(var, CultureInfo.InvariantCulture);
					variant.SetLong(decimal.ToInt64(num2));
					return variant;
				}
				if(type == typeof(double))
				{
					variant.vt = 5;
					return variant;
				}
				if((type == typeof(float)) || (type == typeof(float)))
				{
					variant.vt = 4;
					return variant;
				}
				if(type == typeof(DateTime))
				{
					variant.vt = 7;
					variant.SetLong(Convert.ToDateTime(var, CultureInfo.InvariantCulture).ToFileTime());
					return variant;
				}
				if(type == typeof(sbyte))
				{
					variant.vt = 0x10;
					variant.data1 = (IntPtr)Convert.ToSByte(var, CultureInfo.InvariantCulture);
					return variant;
				}
				if(type == typeof(ushort))
				{
					variant.vt = 0x12;
					variant.data1 = (IntPtr)Convert.ToUInt16(var, CultureInfo.InvariantCulture);
					return variant;
				}
				if(type == typeof(uint))
				{
					variant.vt = 0x13;
					variant.data1 = (IntPtr)Convert.ToUInt32(var, CultureInfo.InvariantCulture);
					return variant;
				}
				if(type == typeof(ulong))
				{
					variant.vt = 0x15;
					variant.SetLong((long)Convert.ToUInt64(var, CultureInfo.InvariantCulture));
					return variant;
				}
				if(((type != typeof(object)) && (type != typeof(Alternative.Win32.IDispatch))) && !type.IsCOMObject)
				{
					throw new ArgumentException("ConnPointUnhandledType");
				}
				variant.vt = (type == typeof(Alternative.Win32.IDispatch)) ? ((short)9) : ((short)13);
				variant.data1 = Marshal.GetIUnknownForObject(var);
			}
			return variant;
		}

		public object ToObject()
		{
			long num;
			int num3;
			IntPtr refInt = this.data1;
			int num2 = this.vt & 0xfff;
			switch(num2)
			{
				case 0:
					return null;
				case 1:
					return Convert.DBNull;
				case 2:
					if(this.Byref)
						refInt = (IntPtr)Marshal.ReadInt16(refInt);
					return (short)(0xffff & ((short)((int)refInt)));
				case 3:
				case 0x16:
					if(this.Byref)
						refInt = (IntPtr)Marshal.ReadInt32(refInt);
					return (int)refInt;
				case 0x10:
					if(this.Byref)
						refInt = (IntPtr)Marshal.ReadByte(refInt);
					return (sbyte)(0xff & ((sbyte)((int)refInt)));
				case 0x11:
					if(this.Byref)
						refInt = (IntPtr)Marshal.ReadByte(refInt);
					return (byte)(0xff & ((byte)((int)refInt)));
				case 0x12:
					if(this.Byref)
						refInt = (IntPtr)Marshal.ReadInt16(refInt);
					return (ushort)(0xffff & ((ushort)((int)refInt)));
				case 0x13:
				case 0x17:
					if(this.Byref)
						refInt = (IntPtr)Marshal.ReadInt32(refInt);
					return (uint)((int)refInt);
				case 20:
				case 0x15:
					if(!this.Byref)
					{
						num = (long)((ulong)((((int)this.data1) & -1) | ((int)this.data2)));
						break;
					}
					num = Marshal.ReadInt64(refInt);
					break;
				default:
					if(this.Byref)
					{
						refInt = GetRefInt(refInt);
					}
					switch(num2)
					{
						case 0xfff:
						case 0x1000:
						case 0x2000:
						case 0x4000:
						case 10:
						case 15:
						case 0x10:
						case 0x11:
						case 0x12:
						case 0x13:
						case 20:
						case 0x15:
						case 0x16:
						case 0x17:
						case 0x18:
						case 0x1a:
						case 0x1b:
						case 0x1c:
						case 0x20:
						case 0x21:
						case 0x22:
						case 0x23:
						case 0x24:
						case 0x41:
						case 0x42:
						case 0x43:
						case 0x44:
						case 0x45:
						case 70:
						case 0x47:
							goto Label_03B7;
						case 4:
						case 5:
							throw new FormatException("CannotConvertIntToFloat");
						case 6:
							return new decimal((long)((ulong)((((int)this.data1) & -1) | ((int)this.data2))));
						case 7:
							throw new FormatException("CannotConvertDoubleToDate");
						case 8:
						case 0x1f:
							return Marshal.PtrToStringUni(refInt);
						case 9:
						case 13:
							return Marshal.GetObjectForIUnknown(refInt);
						case 11:
							return (refInt != IntPtr.Zero);
						case 12:
							{
								VARIANT variant = (VARIANT)Marshal.PtrToStructure(refInt, typeof(VARIANT));
								return variant.ToObject();
							}
						case 14:
							return new decimal((long)((ulong)((((int)this.data1) & -1) | ((int)this.data2))));
						case 0x19:
							return refInt;
						case 0x1d:
							throw new ArgumentException("COM2UnhandledVT");
						case 30:
							return Marshal.PtrToStringAnsi(refInt);
						case 0x40:
							num = (long)((ulong)((((int)this.data1) & -1) | ((int)this.data2)));
							return new DateTime(num);
						case 0x48:
							return (Guid)Marshal.PtrToStructure(refInt, typeof(Guid));
					}
					goto Label_03B7;
			}
			if(this.vt == 20)
			{
				return num;
			}
			return (ulong)num;
		Label_03B7:
			num3 = this.vt;
			throw new ArgumentException("COM2UnhandledVT");
		}

		private static IntPtr GetRefInt(IntPtr value)
		{
			return Marshal.ReadIntPtr(value);
		}


	}
}
