using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;

namespace Alternative.Win32
{
	[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("00020400-0000-0000-C000-000000000046")]
	public interface IDispatch
	{
		int GetTypeInfoCount();
		[return: MarshalAs(UnmanagedType.Interface)]
		ITypeInfo GetTypeInfo([In, MarshalAs(UnmanagedType.U4)] int iTInfo, [In, MarshalAs(UnmanagedType.U4)] int lcid);
		[PreserveSig]
		int GetIDsOfNames([In] ref Guid riid, [In, MarshalAs(UnmanagedType.LPArray)] string[] rgszNames, [In, MarshalAs(UnmanagedType.U4)] int cNames, [In, MarshalAs(UnmanagedType.U4)] int lcid, [Out, MarshalAs(UnmanagedType.LPArray)] int[] rgDispId);
		[PreserveSig]
		int Invoke(int dispIdMember, [In] ref Guid riid, [In, MarshalAs(UnmanagedType.U4)] int lcid, [In, MarshalAs(UnmanagedType.U4)] int dwFlags, [In, Out] tagDISPPARAMS pDispParams, [Out, MarshalAs(UnmanagedType.LPArray)] object[] pVarResult, [In, Out] tagEXCEPINFO pExcepInfo, [Out, MarshalAs(UnmanagedType.LPArray)] IntPtr[] pArgErr);
	}

	[StructLayout(LayoutKind.Sequential)]
	public struct tagDISPPARAMS
	{
		public IntPtr rgvarg;
		public IntPtr rgdispidNamedArgs;
		[MarshalAs(UnmanagedType.U4)]
		public int cArgs;
		[MarshalAs(UnmanagedType.U4)]
		public int cNamedArgs;
	}
	[StructLayout(LayoutKind.Sequential)]
	public struct tagEXCEPINFO
	{
		[MarshalAs(UnmanagedType.U2)]
		public short wCode;
		[MarshalAs(UnmanagedType.U2)]
		public short wReserved;
		[MarshalAs(UnmanagedType.BStr)]
		public string bstrSource;
		[MarshalAs(UnmanagedType.BStr)]
		public string bstrDescription;
		[MarshalAs(UnmanagedType.BStr)]
		public string bstrHelpFile;
		[MarshalAs(UnmanagedType.U4)]
		public int dwHelpContext;
		public IntPtr pvReserved;
		public IntPtr pfnDeferredFillIn;
		[MarshalAs(UnmanagedType.U4)]
		public int scode;
	}


}
