﻿using System;
using System.Windows.Forms;
using Microsoft.VisualBasic.ApplicationServices;

namespace Alternative
{
    using Alternative.Forms;

	internal static class Program
	{
		/// <summary>アプリケーションのメイン エントリ ポイントです。</summary>
		[STAThread]
		static void Main(params string[] args)
		{
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
            new AlternativeApp().Run(args);
		}
	}

    /// <summary>アプリケーションクラスです。</summary>
    internal class AlternativeApp : WindowsFormsApplicationBase
    {
        /// <summary>インスタンスを初期化します。</summary>
        public AlternativeApp()
        {
            this.IsSingleInstance = true;
            this.EnableVisualStyles = true;
            this.SaveMySettingsOnExit = false;
            this.ShutdownStyle = ShutdownMode.AfterMainFormCloses;
        }

        /// <summary>メインフォームを作成する必要があるときに発生します。</summary>
        protected override void OnCreateMainForm()
        {
            this.MainForm = new MainForm();
        }

        /// <summary>単一インスタンス アプリケーションで、後続のインスタンスが起動されると発生します。</summary>
        /// <param name="e">イベント情報を表す <see cref="StartupNextInstanceEventArgs"/>。</param>
        protected override void OnStartupNextInstance(StartupNextInstanceEventArgs e)
        {
            base.OnStartupNextInstance(e);
            if (e.CommandLine.Count > 0)
            {
                try
                {
                    Uri uri = new Uri(e.CommandLine[0]);
                    (this.MainForm as MainForm).LocationUrl(uri.AbsoluteUri);
                }
                catch
                {
                }
            }
        }
    }
}