using System;

namespace Alternative.Functions.BrowserExtension
{
    using Alternative.Controls.Browsers;

    /// <summary>EBhËׂDelayedActionłB̃ANV́AԂ̃uEUɂ̂ݎgpł܂B
	/// gpۂ́A<see cref="WebBrowserAx.RegisterDelayedAction"/><see cref="NavigateState.DocumentCompleted"/>gKɓo^A<see cref="RestoreFirstNavigateUrl"/>Navigate܂B</summary>
	internal class RestoreWindowDelayedAction : DelayedAction
	{
		/// <summary>t@[XgirQ[gURLB</summary>
		public const string RestoreFirstNavigateUrl = "res://ieframe.dll/dnserrordiagoff_webOC.htm";
		/// <summary>ZJhirQ[gURLB</summary>
		public const string RestoreSecondNavigateUrl = "about:blank";

		int _counter;
		ClosedTabData _entries;
		int _restoreSize;

		/// <summary>̃NX̃RXgN^łB</summary>
		/// <param name="entries">u^uṽf[^łB</param>
		public RestoreWindowDelayedAction(ClosedTabData entries, int maxRestoreSize)
		{
			this._counter = 0;
			this._entries = entries;
			this._restoreSize = maxRestoreSize;
		}

		/// <summary>uEUIuWFNg쐬ۂɁA<see cref="ClosedTabData"/>痚𕜌A<see cref="DelayedAction.Action"/>̎łB</summary>
		/// <param name="me">ANVsuEUIuWFNg</param>
		/// <param name="option">ANV̏i[<see cref="DelayedActOption"/></param>
		public override void Action(WebBrowserAx me, DelayedActOption option)
		{
			if(option.Situation != NavigateState.DocumentCompleted) { throw new InvalidOperationException("RestoreWindowDelayedAction̓o^DocumentCompletedłȂ΂Ȃ܂B"); }
			if(this._counter >= 2)
			{
				if(me.Url == option.Url)
				{
					me.History.RestoreEntry(this._entries, this._restoreSize);
					if(this._entries.LockedTab)
					{
						me.RequireLock(true);
					}
				}
				else { option.AutoUnregister = false; }
			}
			else if(this._counter == 1 && option.Url.Equals(RestoreSecondNavigateUrl, StringComparison.OrdinalIgnoreCase))
			{
				this._counter = 2;
				option.AutoUnregister = false;
				me.Navigate(this._entries.Url);
			}
			else if(this._counter == 0 && option.Url.Equals(RestoreFirstNavigateUrl, StringComparison.OrdinalIgnoreCase))
			{
				if(String.IsNullOrEmpty(this._entries.Url)) { return; }
				this._counter = 1;
				option.AutoUnregister = false;
				me.Navigate(RestoreSecondNavigateUrl);
			}
		}
	}
}
