using System;

namespace Alternative.Functions.BrowserExtension
{
    using Alternative.Controls.Browsers;

    /// <summary>\̃y[W_CNgxss<see cref="DelayedAction"/>̎NXłB</summary>
	public class DelayedRedirectAction : DelayedAction
	{
		#region Field

		string _redirectUrl;
		bool _autoUnregister;
		NavigateState _situations;

		#endregion

		#region Constructor

		/// <summary>uEŨirQ[gɑURLփ_CNgs悤ɐݒ肷RXgN^łB</summary>
		/// <param name="redirectUrl">_CNgURL</param>
		public DelayedRedirectAction(string redirectUrl) : this(redirectUrl, NavigateState.DocumentCompleted, true) { }
		/// <summary>URLփ_CNgs悤ɐݒ肷RXgN^łB</summary>
		/// <param name="redirectUrl">_CNgURL</param>
		/// <param name="situationsFilter">Ŏwł̂NavigateError,DownloadCompleted,DocumentCompleted̉ꂩłB</param>
		/// <param name="autoUnregister">truew肷ƁÃ_CNg풓܂Bʏfalsew肵ĂB</param>
		public DelayedRedirectAction(string redirectUrl, NavigateState situationsFilter, bool autoUnregister)
		{
			Uri u;
			if (Uri.TryCreate(redirectUrl, UriKind.RelativeOrAbsolute, out u))
			{
				this._redirectUrl = u.ToString();
			}
			else
			{
				this._redirectUrl = "res://ieframe.dll/dnserror.htm";
			}
			this._autoUnregister = autoUnregister;
			this._situations = NavigateState.DocumentCompleted;
		}

		#endregion

		/// <summary>xs܂Bw肳ꂽURLɁAuEU_CNg܂B</summary>
		/// <param name="me">uEUIuWFNg</param>
		/// <param name="option">ANV̏</param>
		public override void Action(WebBrowserAx me, DelayedActOption option)
		{
			if(me == null) { return; }
			if(option == null) { return; }
			option.AutoUnregister = this._autoUnregister;
			NavigateState ns = option.Situation;
			if((ns & this._situations) == ns)
			{
				if(String.IsNullOrEmpty(me.Url)) { option.AutoUnregister = false; }
				me.Navigate(this._redirectUrl);
			}
		}
	}


}
