using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace Alternative.Forms
{
    using WebServiceClient;

    /// <summary>AvP[V̐ݒʂ񋟂܂B</summary>
    public partial class SettingsForm : Form
    {
        #region Field

        /// <summary>ݒێ <see cref="AlternativeConfig"/>B</summary>
        private AlternativeConfig _config;
        /// <summary>݂̃y[WURL\ stringB</summary>
        private string _currentUrl;

        /// <summary>N̓R{{bNX̍ځB</summary>
        private StartUpAction[] _startUpActionList = new StartUpAction[]
        {
            StartUpAction.OpenPreviousTab,
            StartUpAction.OpenHomeUrl,
            StartUpAction.OpenLockTab,
        };

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public SettingsForm()
        {
            InitializeComponent();

            _currentUrl = "";

            foreach (StartUpAction action in _startUpActionList)
            {
                StartUpActionComboBox.Items.Add(ComponentHelper.GetEnumFieldDescription(action));
            }

            SaveFileFormatLabel.Text = string.Format("t@C̏   {0}F^Cg@{1}FID@{2}Fgq", NicoVideoFile.FileTitleFormat, NicoVideoFile.VideoIdFormat, NicoVideoFile.ExtensionFormat);
        }

        #endregion

        #region Properties

        /// <summary>ҏWݒ񋟂NX擾Eݒ肵܂B</summary>
        public AlternativeConfig AlternativeConfig
        {
            get { return _config; }
            set { _config = value; }
        }

        /// <summary>݂̃y[WURLݒ肵܂(ݐp)B</summary>
        public string CurrentUrl
        {
            set { _currentUrl = value; }
        }

        #endregion

        #region Event Handler

        /// <summary>tH[\Ƃɏlݒ肵܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void SettingsForm_VisibleChanged(object sender, EventArgs e)
        {
            if (this.Visible == true)
            {
                // tH[ɐݒݒ肷
                InitalizeConfigValue();
            }
        }

        /// <summary>uOKv{^ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void OK_Click(object sender, EventArgs e)
        {
            /// ͂`FbN
            if (ValidateConfigValue() == true)
            {
                // ʓ͂ݒNXɔf
                UpdateConfigValue();
                DialogResult = DialogResult.OK;
            }
        }

        /// <summary>uLZv{^ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void Cancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }

        #region Sʃ^u

        /// <summary>ũ݂y[Wgpv{^ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void UseCurrentPageAsHomeButton_Click(object sender, EventArgs e)
        {
            HomeUrlTextBox.Text = _currentUrl;
        }

        /// <summary>uQƁv{^ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void SaveFolderPathButton_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog fbd = new FolderBrowserDialog();
            fbd.SelectedPath = SaveFolderPathTextBox.Text;
            fbd.Description = "ۑtH_I";

            if (fbd.ShowDialog() == DialogResult.OK)
            {
                SaveFolderPathTextBox.Text = fbd.SelectedPath;
            }
        }

        /// <summary>ut@C̏veLXg{bNXƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="CancelEventArgs"/>B</param>
        private void SaveFileFormatComboBox_Validating(object sender, CancelEventArgs e)
        {
            string message;
            int pos;
            if (ValidateSaveFileFormat(out message, out pos) == false)
            {
                SaveFileFormatErrorLabel.Text = message;
                SaveFileFormatComboBox.SelectionStart = pos;
                SaveFileFormatComboBox.SelectionLength = 1;
            }
        }

        #endregion

        #region OC^u

        /// <summary>uALTERNATIVE ̋NɎIɃOCṽ`FbNԂωƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void IsAutoLoginCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            bool enabled = IsAutoLoginCheckBox.Checked;
            LoginMailAddressTextBox.Enabled = enabled;
            LoginPasswordTextBox.Enabled = enabled;
        }

        #endregion

        #region Đ^u

        /// <summary>uSWF t@C̍Đv́uvOwṽ`FbNԂωƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void PlaySwfOnLocalPlayerRadio_CheckedChanged(object sender, EventArgs e)
        {
            bool enadled = PlaySwfOnLocalPlayerRadio.Checked;
            SwfPlayerPathTextBox.Enabled = enadled;
            SwfPlayerPathButton.Enabled = enadled;
        }

        /// <summary>uSWF t@C̍Đv́uQƁv{^ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void SwfPlayerPathButton_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = @"st@C(*.exe)|*.exe|ׂẴt@C(*.*)|*.*";
            ofd.Title = "SWFvC[IĂ";

            if (ofd.ShowDialog() == DialogResult.OK)
            {
                SwfPlayerPathTextBox.Text = ofd.FileName;
            }
        }

        /// <summary>ȗ̓Đv́uvOwṽ`FbNԂωƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void PlayVideoOnLocalPlayerRadio_CheckedChanged(object sender, EventArgs e)
        {
            bool enadled = PlayVideoOnLocalPlayerRadio.Checked;
            OtherPlayerPathTextBox.Enabled = enadled;
            OtherPlayerPathButton.Enabled = enadled;
        }

        /// <summary>ȗ̓Đv́uQƁv{^ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void OtherPlayerPathButton_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = @"st@C(*.exe)|*.exe|ׂẴt@C(*.*)|*.*";
            ofd.Title = "ĐvC[IĂ";

            if (ofd.ShowDialog() == DialogResult.OK)
            {
                OtherPlayerPathTextBox.Text = ofd.FileName;
            }
        }

        #endregion

        #region vLV^u

        /// <summary>uȉ̃vLVgpwṽ`FbNԂωƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void CustomProxyRadio_CheckedChanged(object sender, EventArgs e)
        {
            bool enabled = CustomProxyRadio.Checked;
            ProxyAddressTextBox.Enabled = enabled;
            ProxyPortTextBox.Enabled = enabled;
        }

        /// <summary>uNɃvLṼvONṽ`FbNԂωƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void IsLocalProxyStartUpCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            bool enabled = IsLocalProxyStartUpCheckBox.Checked;
            LocalProxyPathTextBox.Enabled = enabled;
            LocalProxyPathButton.Enabled = enabled;
            LocalProxyStartUpWaitSecondsTextBox.Enabled = enabled;
        }

        /// <summary>
        /// vNVvOIQƃ{^ꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void LocalProxyPathButton_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = @"st@C(*.exe)|*.exe|ׂẴt@C(*.*)|*.*";
            ofd.Title = "vLVvOIĂ";

            if (ofd.ShowDialog() == DialogResult.OK)
            {
                this.LocalProxyPathTextBox.Text = ofd.FileName;
            }
        }

        #endregion

        #endregion

        #region Method

        /// <summary>tH[ɐݒݒ肵܂B</summary>
        private void InitalizeConfigValue()
        {
            // Sʃ^u
            StartUpActionComboBox.SelectedIndex = Array.IndexOf<StartUpAction>(_startUpActionList, _config.StartUpAction);
            HomeUrlTextBox.Text = _config.HomeUrl;
            SaveFolderPathTextBox.Text = _config.SaveFolderPath;
            SaveFileFormatComboBox.Text = _config.SaveFileFormat;
            MaxDownloadConnectionsTextBox.Text = _config.MaxDownloadConnections.ToString();

            // uEU^u
            TabBrowserSettingPage.SetSettingData(_config.TabBrowserSetting);

            // OC^u
            IsAutoLoginCheckBox.Checked = _config.IsAutoLogin;
            if (_config.IsAutoLogin == true)
            {
                LoginMailAddressTextBox.Text = _config.LoginMailAddress;
                LoginPasswordTextBox.Text = _config.LoginPassword;
            }

            // Đ^u
            PlaySwfOnBrowserRadio.Checked = (_config.UseSwfPlayer == false);
            PlaySwfOnLocalPlayerRadio.Checked = (_config.UseSwfPlayer == true);
            if (_config.UseSwfPlayer == true)
            {
                SwfPlayerPathTextBox.Text = _config.SwfPlayerPath;
            }

            PlayVideoOnBrowserRadio.Checked = (_config.UseOtherPlayer == false);
            PlayVideoOnLocalPlayerRadio.Checked = (_config.UseOtherPlayer == true);
            if (_config.UseOtherPlayer == true)
            {
                OtherPlayerPathTextBox.Text = _config.OtherPlayerPath;
            }

            // vLV^u
            ProxyNotUseRadio.Checked = (_config.ProxySetting == ProxySetting.None);
            DefalutProxyRadio.Checked = (_config.ProxySetting == ProxySetting.InternetExplorer);
            CustomProxyRadio.Checked = (_config.ProxySetting == ProxySetting.Custom);
            if (_config.ProxySetting == ProxySetting.Custom)
            {
                ProxyAddressTextBox.Text = _config.ProxyAddress;
                ProxyPortTextBox.Text = _config.ProxyPort.ToString();
            }

            IsLocalProxyStartUpCheckBox.Checked = _config.IsLocalProxyStartUp;
            if (_config.IsLocalProxyStartUp == true)
            {
                LocalProxyPathTextBox.Text = _config.LocalProxyPath;
                LocalProxyStartUpWaitSecondsTextBox.Text = _config.LocalProxyStartUpWaitSeconds.ToString();
            }
        }

        /// <summary>ς݂̃tH[ݒl擾܂B</summary>
        private void UpdateConfigValue()
        {
            // Sʃ^u
            _config.StartUpAction = _startUpActionList[StartUpActionComboBox.SelectedIndex];
            _config.HomeUrl = new Uri(HomeUrlTextBox.Text).AbsoluteUri;
            _config.SaveFolderPath = SaveFolderPathTextBox.Text;
            _config.SaveFileFormat = SaveFileFormatComboBox.Text;
            _config.MaxDownloadConnections = Int32.Parse(MaxDownloadConnectionsTextBox.Text);

            // uEU^u
            _config.TabBrowserSetting = TabBrowserSettingPage.GetSettingData(false);

            // OC^u
            _config.IsAutoLogin = IsAutoLoginCheckBox.Checked;
            if (_config.IsAutoLogin == true)
            {
                _config.LoginMailAddress = LoginMailAddressTextBox.Text;
                _config.LoginPassword = LoginPasswordTextBox.Text;
            }

            // Đ^u
            _config.UseSwfPlayer = PlaySwfOnLocalPlayerRadio.Checked;
            if (_config.UseSwfPlayer == true)
            {
                _config.SwfPlayerPath = SwfPlayerPathTextBox.Text;
            }

            _config.UseOtherPlayer = PlayVideoOnLocalPlayerRadio.Checked;
            if (_config.UseOtherPlayer == true)
            {
                _config.OtherPlayerPath = OtherPlayerPathTextBox.Text;
            }

            // vLV^u
            if (ProxyNotUseRadio.Checked == true) { _config.ProxySetting = ProxySetting.None; }
            if (DefalutProxyRadio.Checked == true) { _config.ProxySetting = ProxySetting.InternetExplorer; }
            if (CustomProxyRadio.Checked == true) { _config.ProxySetting = ProxySetting.Custom; }
            if (_config.ProxySetting == ProxySetting.Custom)
            {
                _config.ProxyAddress = ProxyAddressTextBox.Text;
                _config.ProxyPort = int.Parse(ProxyPortTextBox.Text);
            }

            _config.IsLocalProxyStartUp = IsLocalProxyStartUpCheckBox.Checked;
            if (_config.IsLocalProxyStartUp == true)
            {
                _config.LocalProxyPath = LocalProxyPathTextBox.Text;
                _config.LocalProxyStartUpWaitSeconds = int.Parse(LocalProxyStartUpWaitSecondsTextBox.Text);
            }
        }

        /// <summary>tH[ɓ͂ꂽf[^`FbN܂B</summary>
        /// <returns>tH[̓͂ł <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        private bool ValidateConfigValue()
        {
            #region Sʃ^u

            if (HomeUrlTextBox.Text == "")
            {
                SettingsTab.SelectedTab = GeneralPage;
                MessageBox.Show("z[y[W͂ĂB", Application.ProductName);
                HomeUrlTextBox.Focus();
                return false;
            }

            Uri uri;
            if (Uri.TryCreate(HomeUrlTextBox.Text, UriKind.Absolute, out uri) == false)
            {
                SettingsTab.SelectedTab = GeneralPage;
                MessageBox.Show("z[y[WURLԈĂ܂B", Application.ProductName);
                HomeUrlTextBox.Focus();
                return false;
            }

            if (SaveFolderPathTextBox.Text == "")
            {
                SettingsTab.SelectedTab = GeneralPage;
                MessageBox.Show("ۑtH_͂ĂB", Application.ProductName);
                SaveFolderPathTextBox.Focus();
                return false;
            }

            if (Directory.Exists(SaveFolderPathTextBox.Text) == false)
            {
                SettingsTab.SelectedTab = GeneralPage;
                MessageBox.Show("ۑtH_݂܂B\ntH_쐬ĂB", Application.ProductName);
                SaveFolderPathTextBox.Focus();
                return false;
            }

            string message;
            int pos;
            if (ValidateSaveFileFormat(out message, out pos) == false)
            {
                SettingsTab.SelectedTab = GeneralPage;
                MessageBox.Show(message, Application.ProductName);
                SaveFileFormatComboBox.Focus();
                SaveFileFormatComboBox.SelectionStart = pos;
                SaveFileFormatComboBox.SelectionLength = 1;
                return false;
            }

            if (MaxDownloadConnectionsTextBox.Text == "")
            {
                SettingsTab.SelectedTab = GeneralPage;
                MessageBox.Show("_E[h̍ő吔͂ĂB", Application.ProductName);
                MaxDownloadConnectionsTextBox.Focus();
                return false;
            }

            int maxDownloadConnections;
            if (int.TryParse(MaxDownloadConnectionsTextBox.Text, out maxDownloadConnections) == false)
            {
                SettingsTab.SelectedTab = GeneralPage;
                MessageBox.Show("_E[h̍ő吔ɂ͔p͂ĂB", Application.ProductName);
                MaxDownloadConnectionsTextBox.Focus();
                return false;
            }

            if (maxDownloadConnections < 1 || maxDownloadConnections > 3)
            {
                SettingsTab.SelectedTab = GeneralPage;
                MessageBox.Show("_E[h̍ő吔 1`3 ͈̔͂œ͂ĂB", Application.ProductName);
                MaxDownloadConnectionsTextBox.Focus();
                return false;
            }

            #endregion

            #region OC^u

            if (IsAutoLoginCheckBox.Checked == true)
            {
                if (LoginMailAddressTextBox.Text == "")
                {
                    SettingsTab.SelectedTab = LoginPage;
                    MessageBox.Show("[AhX͂ĂB", Application.ProductName);
                    LoginMailAddressTextBox.Focus();
                    return false;
                }

                if (LoginPasswordTextBox.Text == "")
                {
                    SettingsTab.SelectedTab = LoginPage;
                    MessageBox.Show("pX[h͂ĂB", Application.ProductName);
                    LoginPasswordTextBox.Focus();
                    return false;
                }
            }

            #endregion

            #region Đ

            if (PlaySwfOnLocalPlayerRadio.Checked)
            {
                if (SwfPlayerPathTextBox.Text == "")
                {
                    SettingsTab.SelectedTab = PlayerPage;
                    MessageBox.Show("SWF t@CĐvC[̃pX͂Ă܂B", Application.ProductName);
                    SwfPlayerPathTextBox.Focus();
                    return false;
                }
            }

            if (PlayVideoOnLocalPlayerRadio.Checked)
            {
                if (OtherPlayerPathTextBox.Text == "")
                {
                    SettingsTab.SelectedTab = PlayerPage;
                    MessageBox.Show("t@CĐvC[̃pX͂Ă܂B", Application.ProductName);
                    OtherPlayerPathTextBox.Focus();
                    return false;
                }
            }

            #endregion

            #region vLV

            if (CustomProxyRadio.Checked == true)
            {
                if (ProxyAddressTextBox.Text == "")
                {
                    SettingsTab.SelectedTab = ProxyPage;
                    MessageBox.Show("vLV T[o[̃AhX͂Ă܂B", Application.ProductName);
                    ProxyAddressTextBox.Focus();
                    return false;
                }

                if (ProxyPortTextBox.Text == "")
                {
                    SettingsTab.SelectedTab = ProxyPage;
                    MessageBox.Show("vLV T[o[̃|[gԍ͂Ă܂B", Application.ProductName);
                    ProxyPortTextBox.Focus();
                    return false;
                }

                int proxyPort;
                if (int.TryParse(ProxyPortTextBox.Text, out proxyPort) == false)
                {
                    SettingsTab.SelectedTab = ProxyPage;
                    MessageBox.Show("vLV T[o[̃|[gԍɂ͔p͂ĂB", Application.ProductName);
                    ProxyPortTextBox.Focus();
                    return false;
                }

                if (proxyPort < 1 || proxyPort > 65535)
                {
                    SettingsTab.SelectedTab = ProxyPage;
                    MessageBox.Show("vLV T[o[̃|[gԍ 1`65535 ͈̔͂œ͂ĂB", Application.ProductName);
                    ProxyPortTextBox.Focus();
                    return false;
                }
            }

            if (IsLocalProxyStartUpCheckBox.Checked == true)
            {
                if (LocalProxyPathTextBox.Text == "")
                {
                    SettingsTab.SelectedTab = ProxyPage;
                    MessageBox.Show("[J vLṼpX͂Ă܂B", Application.ProductName);
                    LocalProxyPathTextBox.Focus();
                    return false;
                }

                if (LocalProxyStartUpWaitSecondsTextBox.Text == "")
                {
                    SettingsTab.SelectedTab = ProxyPage;
                    MessageBox.Show("[J vLV̋N҂Ԃ͂Ă܂B", Application.ProductName);
                    LocalProxyStartUpWaitSecondsTextBox.Focus();
                    return false;
                }

                int proxyPort;
                if (int.TryParse(LocalProxyStartUpWaitSecondsTextBox.Text, out proxyPort) == false)
                {
                    SettingsTab.SelectedTab = ProxyPage;
                    MessageBox.Show("[J vLV̋N҂Ԃɂ͔p͂ĂB", Application.ProductName);
                    LocalProxyStartUpWaitSecondsTextBox.Focus();
                    return false;
                }

                if (proxyPort < 0 || proxyPort > 30)
                {
                    SettingsTab.SelectedTab = ProxyPage;
                    MessageBox.Show("[J vLV̋N҂Ԃ 0`30 ͈̔͂œ͂ĂB", Application.ProductName);
                    LocalProxyStartUpWaitSecondsTextBox.Focus();
                    return false;
                }
            }

            #endregion

            return true;
        }

        /// <summary>ut@C̏v̓͂܂B</summary>
        /// <param name="errorMessage">G[bZ[Wi[ stringB</param>
        /// <param name="pos">G[õCfbNX\ intB</param>
        /// <returns>͂킾ꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        private bool ValidateSaveFileFormat(out string errorMessage, out int pos)
        {
            if (SaveFileFormatComboBox.Text == "")
            {
                errorMessage = "t@C̏͂ĂB";
                pos = 0;
                return false;
            }

            string format = SaveFileFormatComboBox.Text;
            format = format.Replace(NicoVideoFile.FileTitleFormat, new string('T', NicoVideoFile.FileTitleFormat.Length));
            format = format.Replace(NicoVideoFile.ExtensionFormat, new string('E', NicoVideoFile.ExtensionFormat.Length));

            Regex regex = new Regex(string.Format("(?<error>[0-9A-Za-z]{0}|{0}[0-9A-Za-z])", NicoVideoFile.VideoIdFormat));
            Match match = regex.Match(format);
            if (match.Success == true)
            {
                errorMessage = string.Format("{0} ^O͔ppȊO̕ň͂łB", NicoVideoFile.VideoIdFormat);
                pos = match.Index;
                return false;
            }

            format = format.Replace(NicoVideoFile.VideoIdFormat, new string('I', NicoVideoFile.VideoIdFormat.Length));
            foreach (char test in Path.GetInvalidFileNameChars())
            {
                pos = format.IndexOf(test);
                if (pos != -1)
                {
                    errorMessage = "t@C̏ɎgpłȂ܂܂Ă܂B";
                    return false;
                }
            }

            errorMessage = "";
            pos = -1;
            return true;
        }

        #endregion
    }
}