using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Xml;
using System.Xml.Serialization;

namespace Alternative.Forms
{
    /// <summary>t@C_CAOB</summary>
	public partial class SearchFileDialog : Form
    {
        #region Field

        /// <summary>t@C_CAO̐ݒ\ <see cref="SearchFileDialogInfo"/>B</summary>
        private SearchFileInfo _info;
        /// <summary>Ōt@C\ <see cref="FileInfo">FileInfo[]</see></summary>
        private FileInfo[] _files;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public SearchFileDialog()
            : this(new SearchFileInfo())
		{
        }

        /// <summary>CX^X܂B</summary>
        /// <param name="info">t@C_CAO̐ݒ\ <see cref="SearchFileDialogInfo"/>B</param>
        public SearchFileDialog(SearchFileInfo info)
        {
            if (info == null)
            {
                throw new ArgumentNullException();
            }

            _info = info;
            _files = new FileInfo[0];

            InitializeComponent();
        }

        #endregion

        #region Property

        /// <summary>L[[ȟ擾܂(ǂݎp)B</summary>
        public List<string> Keywords
        {
            get { return _info.Keywords; }
        }

        /// <summary>Ώۂ̃tH_̌擾܂(ǂݎp)B</summary>
        public List<string> Folders
        {
            get { return _info.Folders; }
        }

        /// <summary>TutH_邩ǂ擾Eݒ肵܂B</summary>
        public bool SubFolderSraech
        {
            get { return _info.SubFolderSearch; }
            set { _info.SubFolderSearch = value; }
        }

        /// <summary>K\gp邩ǂ擾Eݒ肵܂B</summary>
        public bool RegexSearch
        {
            get { return _info.RegexSearch; }
            set { _info.RegexSearch = value; }
        }

        /// <summary>\Ɏgp錟L[[ȟ擾Eݒ肵܂B</summary>
        public string DefaultKeyword
        {
            get { return _info.DefaultKeyword; }
            set { _info.DefaultKeyword = value; }
        }

        /// <summary>\Ɏgp錟Ώۂ̃tH_̌擾Eݒ肵܂B</summary>
        public string DefaultFolder
        {
            get { return _info.DefaultFolder; }
            set { _info.DefaultFolder = value; }
        }

        /// <summary>ʂ̃t@C擾܂(ǂݎp)B</summary>
        public FileInfo[] ResultFiles
        {
            get { return _files; }
        }

        /// <summary>t@C_CAO̐ݒ擾܂(ǂݎp)B</summary>
        public SearchFileInfo SearchFileInfo
        {
            get { return _info; }
        }

        #endregion

        #region Event Handler

        /// <summary>tH[\Ƃɏlݒ肵܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void SearchFileDialog_VisibleChanged(object sender, EventArgs e)
        {
            if (this.Visible == true)
            {
                KeywordComboBox.Text = _info.DefaultKeyword;
                FolderComboBox.Text = _info.DefaultFolder;
                SubFolderCheckBox.Checked = _info.SubFolderSearch;
                RegexCheckBox.Checked = _info.RegexSearch;

                KeywordComboBox.Items.Clear();
                KeywordComboBox.Items.AddRange(_info.Keywords.ToArray());

                FolderComboBox.Items.Clear();
                FolderComboBox.Items.AddRange(_info.Folders.ToArray());
            }
            else
            {
                _info.DefaultKeyword = KeywordComboBox.Text;
                _info.DefaultFolder = FolderComboBox.Text;
                _info.SubFolderSearch = SubFolderCheckBox.Checked;
                _info.RegexSearch = RegexCheckBox.Checked;
            }
        }

        /// <summary>Qƃ{^ꂽtH_I_CAO\܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void FolderButton_Click(object sender, EventArgs e)
        {
            using (FolderBrowserDialog dialog = new FolderBrowserDialog())
            {
                dialog.Description = "tH_IOK{^ĂB";
                dialog.SelectedPath = (FolderComboBox.Text.Length > 0) ? FolderComboBox.Text : _info.DefaultFolder;
                DialogResult result = dialog.ShowDialog();

                if (result == DialogResult.OK)
                {
                    FolderComboBox.Text = dialog.SelectedPath;
                }
            }
        }

        /// <summary>{^ꂽ猟`FbN܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void OK_Click(object sender, EventArgs e)
        {
            if (KeywordComboBox.Text.Length > 0)
            {
                if (RegexCheckBox.Checked == false)
                {
                    foreach (char test in Path.GetInvalidFileNameChars())
                    {
                        if (test != '*' && test != '?' && KeywordComboBox.Text.IndexOf(test) != -1)
                        {
                            MessageBox.Show("sȕ " + KeywordComboBox.SelectedText + " ܂܂Ă܂B", Application.ProductName);
                            KeywordComboBox.Focus();
                            KeywordComboBox.SelectionStart = KeywordComboBox.Text.IndexOf(test);
                            KeywordComboBox.SelectionLength = 1;
                            return;
                        }
                    }
                }
                else
                {
                    try
                    {
                        Regex.IsMatch("", KeywordComboBox.Text, _info.RegexOptions);
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show("sȐK\łB\n" + ex.Message, Application.ProductName);
                        KeywordComboBox.Focus();
                        return;
                    }
                }
            }

            if (Directory.Exists(FolderComboBox.Text) == false)
            {
                MessageBox.Show("tH_݂܂B", Application.ProductName);
                FolderComboBox.Focus();
                return;
            }

            this.DialogResult = DialogResult.OK;
        }

        #endregion
    }

    /// <summary>t@C̐ݒ񋟂܂B</summary>
    [Serializable()]
    [XmlType("SearchFileInfoRoot")]
    public class SearchFileInfo
    {
        #region Constant

        /// <summary>ێ錟L[[h̍ő吔\ intB</summary>
        public const int MaxKeywordHistory = 100;
        /// <summary>ێ錟tH_̍ő吔\ intB</summary>
        public const int MaxFoldersHistory = 20;

        #endregion

        #region Field

        /// <summary>L[[ȟ\ <see cref="List{T}">List&lt;string&gt;</see>B</summary>
        [XmlElement("Keywords", typeof(List<string>), IsNullable = false)]
        private List<string> _keywords;
        /// <summary>Ώۂ̃tH_̌\ <see cref="ThumbnailInfoErrorXml"/>B</summary>
        [XmlElement("Folders", typeof(List<string>), IsNullable = false)]
        private List<string> _folders;
        /// <summary>TutH_邩ǂ\ boolB</summary>
        [XmlElement("SubFolderSearch", typeof(bool), IsNullable = false)]
        private bool _subFolderSearch;
        /// <summary>K\gp邩ǂ\ boolB</summary>
        [XmlElement("RegexSearch", typeof(bool), IsNullable = false)]
        private bool _regexSearch;
        /// <summary>\Ɏgp錟L[[h\ stringB</summary>
        [XmlIgnore()]
        private string _defaultKeyword;
        /// <summary>\Ɏgp錟Ώۂ̃tH_\ stringB</summary>
        [XmlIgnore()]
        private string _defaultFolder;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public SearchFileInfo()
        {
            _keywords = new List<string>();
            _folders = new List<string>();
            _subFolderSearch = false;
            _regexSearch = false;
            _defaultKeyword = "";
            _defaultFolder = "";
        }

        #endregion

        #region Property

        /// <summary>L[[ȟ擾܂(ǂݎp)B</summary>
        public List<string> Keywords
        {
            get { return _keywords; }
        }

        /// <summary>Ώۂ̃tH_̌擾܂(ǂݎp)B</summary>
        public List<string> Folders
        {
            get { return _folders; }
        }

        /// <summary>TutH_邩ǂ擾Eݒ肵܂B</summary>
        public bool SubFolderSearch
        {
            get { return _subFolderSearch; }
            set { _subFolderSearch = value; }
        }

        /// <summary>K\gp邩ǂ擾Eݒ肵܂B</summary>
        public bool RegexSearch
        {
            get { return _regexSearch; }
            set { _regexSearch = value; }
        }

        /// <summary>\Ɏgp錟L[[ȟ擾Eݒ肵܂B</summary>
        public string DefaultKeyword
        {
            get { return _defaultKeyword; }
            set { _defaultKeyword = value ?? ""; }
        }

        /// <summary>\Ɏgp錟Ώۂ̃tH_̌擾Eݒ肵܂B</summary>
        public string DefaultFolder
        {
            get { return _defaultFolder; }
            set { _defaultFolder = value ?? ""; }
        }

        /// <summary>Regex NXɎw肷鐳K\IvV擾܂(ǂݎp)B</summary>
        public RegexOptions RegexOptions
        {
            get { return RegexOptions.ExplicitCapture | RegexOptions.IgnoreCase; }
        }

        #endregion

        #region Method

        /// <summary>݂̏Ńt@C܂B</summary>
        /// <returns>t@C\ <see cref="FileInfo">FileInfo[]</see>B</returns>
        public FileInfo[] Search()
        {
            FileInfo[] result;
            Regex regex = null;
            SearchOption options = (_subFolderSearch == true) ? SearchOption.AllDirectories : SearchOption.TopDirectoryOnly;

            if (_regexSearch == true && _defaultKeyword.Length > 0)
            {
                regex = new Regex(_defaultKeyword, RegexOptions);
            }

            if (_defaultFolder.Length == 0)
            {
                throw new InvalidOperationException("Ώۂ̃tH_ݒ肳Ă܂B");
            }
            else if (Directory.Exists(_defaultFolder) == false)
            {
                throw new InvalidOperationException("Ώۂ̃tH_݂܂B");
            }

            if (_defaultKeyword.Length == 0)
            {
                result = new DirectoryInfo(_defaultFolder).GetFiles("*", options);
            }
            else if (_regexSearch == false)
            {
                string keyword = _defaultKeyword.Trim(new char[] { '*' });
                result = new DirectoryInfo(_defaultFolder).GetFiles("*" + _defaultKeyword + "*", options);
            }
            else
            {
                List<FileInfo> files = new List<FileInfo>();
                foreach (FileInfo item in new DirectoryInfo(_defaultFolder).GetFiles("*", options))
                {
                    if (regex.IsMatch(item.FullName) == true)
                    {
                        files.Add(item);
                    }
                }
                result = files.ToArray();
            }

            // L[[h𗚗ɒǉ
            if (_defaultKeyword.Length > 0)
            {
                int keywordIndex = _keywords.IndexOf(_defaultKeyword);
                if (keywordIndex != -1)
                {
                    _keywords.RemoveAt(keywordIndex);
                }
                else if (_keywords.Count >= MaxKeywordHistory)
                {
                    _keywords.RemoveAt(MaxKeywordHistory - 1);
                }
                _keywords.Insert(0, _defaultKeyword);
            }

            // tH_𗚗ɒǉ
            int folderIndex = _folders.IndexOf(_defaultFolder);
            if (folderIndex != -1)
            {
                _folders.RemoveAt(folderIndex);
            }
            else if (_folders.Count >= MaxFoldersHistory)
            {
                _folders.RemoveAt(MaxFoldersHistory - 1);
            }
            _folders.Insert(0, _defaultFolder);

            return result;
        }

        #endregion
    }
}