using System;
using System.IO;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace Alternative.Forms
{
    using WebServiceClient.Forms;
    using WebServiceClient.NicoVideo;
    using Alternative.Controls.Browsers;

    public partial class MainForm
    {
        #region TabBrowserControl֘A

        private static Regex Regex_UrlIsNicoWatchPage = new Regex("^http://(?<locale>www|de|tw|es)\\.nicovideo\\.jp/watch/(?<movieid>[a-zA-Z]{0,2}?[\\d]{1,12})", RegexOptions.Compiled | RegexOptions.IgnoreCase);

		#region +---- EventHandlers

		/// <summary>
        /// _E[hNꂽۂ̃CxgłB
        /// DownloadListViewListViewItemǉ܂B
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێMovieDownloadRequiredEventArgsIuWFNg</param>
        private void tabBrowser_MovieDownloadRequired(object sender, MovieDownloadRequiredEventArgs e)
        {
			VideoPageUrl url = VideoPageUrlCreator.CreateUrl(e.Url);

            if (url is NicoVideoPageUrl)
			{
				NicoVideoPageUrl nicoUrl = (url as NicoVideoPageUrl);
                string videoId = nicoUrl.VideoId;
                string title = e.NewName ?? e.DisplayTitle ?? videoId;
                string format = _config.SaveFullPathFormat;
                DownloadTarget target = DownloadTarget.Default;
                string itemKey = Path.Combine(_config.SaveFolderPath, videoId);
                IDownloadItem downItem = null;

                // Oςă_E[h
                if (e.IsDetailMode == true)
                {
                    using (InputNewTitleDialog newTitleDialg = new InputNewTitleDialog())
                    {
                        newTitleDialg.NewTitle = e.DisplayTitle;

                        if (newTitleDialg.ShowDialog() == DialogResult.Cancel)
                        {
                            return;
                        }

                        title = newTitleDialg.NewTitle;
                        itemKey = itemKey + '\t' + title;
                        format = format.Replace(NicoVideoFile.FileTitleFormat, title);
                    }
                }

                // _E[hXgɎsœo^ς݂̏ꍇ̓G[bZ[W\
                if (_downloadManager.Contains(itemKey) == true)
                {
                    downItem = _downloadManager[itemKey];
                    switch (downItem.State)
                    {
                    case DownloadItemState.Start:
                    case DownloadItemState.Waiting:
                    case DownloadItemState.Processing:
                    case DownloadItemState.Pause:
                        MessageBox.Show("Ƀ_E[ho^Ă܂B", Application.ProductName);
                        return;
                    }
                }

                // d`FbN
                if (ShowDownFileExistDialog(videoId) == false)
                {
                    return;
                }

                // _E[hACeo^
                if (downItem != null)
                {
                    _downloadManager.RemoveItem(itemKey);
                    _downloadManager.AddItem(itemKey, downItem);
                }
                else
                {
                    downItem = new NicoDownloadItem(videoId, title, format, target);
                    _downloadManager.AddItem(itemKey, downItem);
                }

                // ^XNJn
                if (e.IsReserveMode == false)
                {
                    _downloadManager.Start(downItem);
                }

                SaveFolderTreeView.SelectedNode = SaveFolderTreeView.Nodes[DownloadNodeKey];
			}
			else
			{
                MessageBox.Show("URL̃_E[h̓T|[g܂B", Application.ProductName);
            }
        }

        private void tabBrowser_TbDocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            ITbPageControl page = sender as ITbPageControl;
            if (page != null && page.DisplayUrl == e.Url.AbsoluteUri)
            {
                switch (e.Url.Scheme)
                {
                case "http":
                case "https":
                case "ftp":
                case "ftps":
                    string stitle = page.DisplayTitle;
                    string surl = e.Url.AbsoluteUri;
                    if (stitle == String.Empty) stitle = surl;
                    this.history_Add(stitle, surl);
                    break;
                }
            }
        }

        private void tabBrowser_TbDisplayTitleChanged(ITbPageControl sender, ITbDisplayEventArgs e)
        {
            this.Text = Application.ProductName + " - " + this.tabBrowser.TbTitle;
        }
        private void tabBrowser_TbDisplayUrlChanged(ITbPageControl sender, ITbDisplayEventArgs e)
        {
            if (!this.ToolStripUrlTextBox.Focused)
                this.ToolStripUrlTextBox.Text = this.tabBrowser.TbUrl;

            this.ToolStripDownloadButton.Enabled = Regex_UrlIsNicoWatchPage.IsMatch(this.tabBrowser.TbUrl);
        }
        private void tabBrowser_TbDisplayStatusTextChanged(ITbPageControl sender, ITbDisplayEventArgs e)
        {
        }

        private void tabBrowser_TbCanGoBackChanged(object sender, EventArgs e)
        {
            this.ToolStripBackButton.Enabled = this.tabBrowser.TbCanGoBack;
        }
        private void tabBrowser_TbCanGoForwardChanged(object sender, EventArgs e)
        {
            this.ToolStripForwardButton.Enabled = this.tabBrowser.TbCanGoForward;
        }

        private void tabBrowser_TbSelectedIndexChanged(object sender, EventArgs e)
        {
            this.ToolStripUrlTextBox.Text = this.tabBrowser.TbUrl;
            this.Text = Application.ProductName + " - " + this.tabBrowser.TbTitle;
            this.ToolStripBackButton.Enabled = this.tabBrowser.TbCanGoBack;
			this.ToolStripForwardButton.Enabled = this.tabBrowser.TbCanGoForward;
            this.ToolStripDownloadButton.Enabled = Regex_UrlIsNicoWatchPage.IsMatch(this.tabBrowser.TbUrl);
		}

		#endregion

		/// <summary>
		/// uEȖJڂs܂B
		/// </summary>
		/// <param name="URL">JڐURL</param>
		private void Navigate(string URL)
		{
			Uri u = null;
			if(Uri.TryCreate(URL, UriKind.Absolute, out u))
			{
				this.tabBrowser.TbNavigate(u);
			}
            else { MessageBox.Show("URL܂B", Application.ProductName); }
		}

		private void Navigate(string url, bool opennew)
		{
			if(opennew)
			{
				this.tabBrowser.TbOpenNewTab(url, this.tabBrowser.TbSelectedIndex + 1, true);
			}
			else
			{
				Uri u = null;
				if(Uri.TryCreate(url, UriKind.Absolute, out u))
					this.tabBrowser.TbNavigate(u, true);
				else
                    MessageBox.Show(String.Format("URĽ`słB\n> {0}", url), Application.ProductName);
			}
		}

		#endregion

		#region FavoriteTreeView֘A

		/// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAddFavorite_Click(object sender, EventArgs e)
        {
            if (this.tabBrowser.TbSelectedBrowser != null)
            {
                string title = this.tabBrowser.TbSelectedBrowser.DocumentTitle;
                string url = this.tabBrowser.TbSelectedBrowser.Url;
                this.FavoriteTreeView.FvAddPageCustom(title, url, String.Empty);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void favoriteTreeView_FvNavigateRequired(object sender, Alternative.Functions.NavigateRequiredEventArgs e)// Add 080830 - BaseVer0.0.10
        {
			if(this.InvokeRequired)
			{
				this.Invoke((MethodInvoker)delegate { this.Navigate(e.Url, e.OpenNew); });
			}
			else
			{
				this.Navigate(e.Url, e.OpenNew);
			}
        }



        #endregion

        #region  SidePanel֘A(EventHandler)

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tabSideBar_SelectedIndexChanged(object sender, EventArgs e)
        {
            int selindex = this.SideBarTab.SelectedIndex;
            if (selindex == 0)
            {
                ToolStripFavoriteButton.Checked = true;
                ToolStripFavoriteButton_Click(sender, e);

                AddFavoriteButton.Visible = true;
                AddFavoriteButton.Enabled = true;
            }
            else if (selindex == 1)
            {
                ToolStripHistoryButton.Checked = true;
                ToolStripHistoryButton_Click(sender, e);

                AddFavoriteButton.Visible = false;
                AddFavoriteButton.Enabled = false;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void splitContainerBrowsSidebar_SplitterMoved(object sender, SplitterEventArgs e)
        {
            AddFavoriteButton.Left = e.SplitX - AddFavoriteButton.Width;
            this.SideBarTab.Width = e.SplitX + 4;
        }



		#region ֘A

		/// <summary>̍őێ</summary>
        int history_max_count = 100;

        private void history_Add(string title, string url)
        {
            if (HistoryListView.Items.ContainsKey(url) == true)
            {
                HistoryListView.Items.Move(url, HistoryListView.Items[0].Name);
            }
            else
            {
                while (HistoryListView.Items.Count >= history_max_count)
                {
                    HistoryListView.Items.RemoveAt(HistoryListView.Items.Count - 1);
                }

                GkListViewItem item = new GkListViewItem();
                item.Text = title;
                item.Tag = (object)url;
                item.ToolTipText = title + "\n" + url;
                HistoryListView.Items.Insert(0, url, item);
            }
        }

        private string history_Get(int entry) // Add 080830 - BaseVer0.0.10
        {
            if (0 <= entry && entry < HistoryListView.Items.Count)
            {
                return (string)HistoryListView.Items[entry].Tag;
            }
            else return string.Empty;
        }
        private bool history_Remove(int entry) // Add 080830 - BaseVer0.0.10
        {
            if (0 <= entry && entry < HistoryListView.Items.Count)
            {
                HistoryListView.Items.RemoveAt(entry);
                return true;
            }
            return false;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void HistoryListView_ItemActivate(object sender, EventArgs e)
        {
            if (HistoryListView.FocusedItem.Tag != null)
            {
                string url = (string)HistoryListView.FocusedItem.Tag;
                HistoryListView.Items.Remove(HistoryListView.FocusedItem);
                Uri u = null;

                if (Uri.TryCreate(url, UriKind.Absolute, out u))
                {
                    this.tabBrowser.TbNavigate(u);
                }
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void HistoryListView_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Middle)
            {
                ListViewItem item = HistoryListView.GetItemAt(e.X, e.Y);
                if (item != null)
                {
                    if (item.Bounds.Contains(e.Location))
                    {
                        string url = (string)item.Tag;
                        this.tabBrowser.TbOpenNewTab(url, this.tabBrowser.TbSelectedIndex + 1, true);
                    }
                }
            }
        }

        private void HistoryListView_Resize(object sender, EventArgs e)
        {
            listHistoryClmn_Title.Width = HistoryListView.Width - 5;
        }

		#endregion

        #endregion
	}
}
